##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
#
##
# Version 0.2 # 1999-12-31 # Your Name      # <----- updated from tutorial 1
# Added cookie detection
##
Plugin.define "Plugin-Tutorial-3" do
author "Your preferred name <email@address>" # 1999-12-31
version "0.2" # <----- updated from tutorial 1
description "Generic CMS is an open-source Content Management System developed in PHP."
website "http://example.com/"

# The Google Dorks list is an array. This can help people find the product using a search engine.
# Dorks #     # <----- updated from tutorial 1
dorks [
'"Generic CMS login"',
'Generic login register linkname',
]

# This is the matches array. 
# Each match is treated independently.

# Matches #
matches [

	# This searches for a text string.
	{ :text => "This page was generated by <b>Generic CMS</b>" },

	# This searches for a regular expression. Note that the slashes are escaped.
	{ :regexp => /This page was generated by <a href="http:\/\/www.genericcms.com\/en\/products\/generic-cms\/">Generic CMS<\/a>/ },

	# This extracts the version of Generic CMS from the Mega generator tag.
	{ :name => "Meta generator",  :version => /<meta name="generator" content="Generic CMS version ([a-z0-9])+/ },

	# Generic Cookie  # <----- updated from tutorial 1
	# This detects the generic CMS cookie. Note the :search is set to "headers[set-cookie]"
	{ :search => "headers[set-cookie]", :regexp => /genericcms=[^;]+;/ },
	
] 


end
