.\" $XdotOrg: lib/X11/man/XPutImage.man,v 1.3 2005-08-16 19:23:15 alanc Exp $
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XPutImage.man,v 1.3 2001/02/09 03:47:46 tsi Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XPutImage 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XPutImage, XGetImage, XGetSubImage \- transfer images
.SH SYNTAX
.HP
int XPutImage\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, GC \fIgc\fP\^,
XImage *\fIimage\fP\^, int \fIsrc_x\fP\^, int \fIsrc_y\fP\^, int
\fIdest_x\fP\^, int \fIdest_y\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^); 
.HP
XImage *XGetImage\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, int
\fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, unsigned long \fIplane_mask\fP\^, int \fIformat\fP\^); 
.HP
XImage *XGetSubImage\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^, int
\fIx\fP\^, int \fIy\fP\^, unsigned int \fIwidth\fP\^, unsigned int
\fIheight\fP\^, unsigned long \fIplane_mask\fP\^, int \fIformat\fP\^, XImage
*\fIdest_image\fP\^, int \fIdest_x\fP\^, \fIdest_y\fP\^); 
.SH ARGUMENTS
.IP \fId\fP 1i
Specifies the drawable. 
.IP \fIdest_image\fP 1i
Specifies the destination image.
.ds Dx , which are relative to the origin of the drawable \
and are the coordinates of the subimage \
or which are relative to the origin of the destination rectangle, \
specify its upper-left corner, and determine where the subimage \
is placed in the destination image
.IP \fIdest_x\fP 1i
.br
.ns
.IP \fIdest_y\fP 1i
Specify the x and y coordinates\*(Dx.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIformat\fP 1i
Specifies the format for the image.
You can pass
.ZN XYPixmap
or 
.ZN ZPixmap .
.IP \fIgc\fP 1i
Specifies the GC.
.IP \fIimage\fP 1i
Specifies the image you want combined with the rectangle. 
.IP \fIplane_mask\fP 1i
Specifies the plane mask.
.\" *** JIM: NEED MORE INFO FOR THIS. ***
.IP \fIsrc_x\fP 1i
Specifies the offset in X from the left edge of the image defined
by the 
.ZN XImage 
structure.
.IP \fIsrc_y\fP 1i
Specifies the offset in Y from the top edge of the image defined
by the 
.ZN XImage 
structure.
.ds Wh \ of the subimage, which define the dimensions of the rectangle
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height\*(Wh.
.ds Xy , which are relative to the origin of the drawable \
and define the upper-left corner of the rectangle
.IP \fIx\fP 1i
.br
.ns
.IP \fIy\fP 1i
Specify the x and y coordinates\*(Xy.
.SH DESCRIPTION
The
.ZN XPutImage
function
combines an image with a rectangle of the specified drawable.
The section of the image defined by the src_x, src_y, width, and height 
arguments is drawn on the specified part of the drawable.
If 
.ZN XYBitmap 
format is used, the depth of the image must be one,
or a
.ZN BadMatch 
error results.
The foreground pixel in the GC defines the source for the one bits in the image,
and the background pixel defines the source for the zero bits.
For 
.ZN XYPixmap 
and 
.ZN ZPixmap , 
the depth of the image must match the depth of the drawable,
or a
.ZN BadMatch
error results.
.LP
If the characteristics of the image (for example, byte_order and bitmap_unit)
differ from what the server requires,
.ZN XPutImage 
automatically makes the appropriate
conversions.
.LP
This function uses these GC components: 
function, plane-mask, subwindow-mode, clip-x-origin, clip-y-origin, 
and clip-mask.
It also uses these GC mode-dependent components:
foreground and background.
.LP
.ZN XPutImage
can generate
.ZN BadDrawable ,
.ZN BadGC ,
.ZN BadMatch ,
and
.ZN BadValue 
errors.
.LP
The
.ZN XGetImage
function returns a pointer to an
.ZN XImage
structure.
This structure provides you with the contents of the specified rectangle of
the drawable in the format you specify.
If the format argument is 
.ZN XYPixmap ,
the image contains only the bit planes you passed to the plane_mask argument.
If the plane_mask argument only requests a subset of the planes of the
display, the depth of the returned image will be the number of planes
requested.
If the format argument is 
.ZN ZPixmap ,
.ZN XGetImage
returns as zero the bits in all planes not 
specified in the plane_mask argument.
The function performs no range checking on the values in plane_mask and ignores
extraneous bits.
.LP
.ZN XGetImage
returns the depth of the image to the depth member of the
.ZN XImage
structure.
The depth of the image is as specified when the drawable was created,
except when getting a subset of the planes in 
.ZN XYPixmap
format, when the depth is given by the number of bits set to 1 in plane_mask.
.LP
If the drawable is a pixmap, 
the given rectangle must be wholly contained within the pixmap, 
or a
.ZN BadMatch
error results.
If the drawable is a window, 
the window must be viewable, 
and it must be the case that if there were no inferiors or overlapping windows,
the specified rectangle of the window would be fully visible on the screen
and wholly contained within the outside edges of the window,
or a
.ZN BadMatch
error results.
Note that the borders of the window can be included and read with
this request.
If the window has backing-store, the backing-store contents are
returned for regions of the window that are obscured by noninferior
windows. 
If the window does not have backing-store,
the returned contents of such obscured regions are undefined.
The returned contents of visible regions of inferiors
of a different depth than the specified window's depth are also undefined.
The pointer cursor image is not included in the returned contents.
If a problem occurs,
.ZN XGetImage
returns NULL.
.LP
.ZN XGetImage
can generate
.ZN BadDrawable ,
.ZN BadMatch ,
and
.ZN BadValue 
errors.
.LP
The 
.ZN XGetSubImage 
function updates dest_image with the specified subimage in the same manner as 
.ZN XGetImage . 
If the format argument is 
.ZN XYPixmap ,
the image contains only the bit planes you passed to the plane_mask argument.
If the format argument is 
.ZN ZPixmap ,
.ZN XGetSubImage
returns as zero the bits in all planes not 
specified in the plane_mask argument.
The function performs no range checking on the values in plane_mask and ignores
extraneous bits.
As a convenience,
.ZN XGetSubImage
returns a pointer to the same
.ZN XImage
structure specified by dest_image.
.LP
The depth of the destination
.ZN XImage
structure must be the same as that of the drawable.
If the specified subimage does not fit at the specified location
on the destination image, the right and bottom edges are clipped.
If the drawable is a pixmap,
the given rectangle must be wholly contained within the pixmap,
or a
.ZN BadMatch
error results.
If the drawable is a window, 
the window must be viewable, 
and it must be the case that if there were no inferiors or overlapping windows,
the specified rectangle of the window would be fully visible on the screen
and wholly contained within the outside edges of the window,
or a
.ZN BadMatch
error results.
If the window has backing-store, 
then the backing-store contents are returned for regions of the window 
that are obscured by noninferior windows. 
If the window does not have backing-store, 
the returned contents of such obscured regions are undefined.
The returned contents of visible regions of inferiors
of a different depth than the specified window's depth are also undefined.
If a problem occurs,
.ZN XGetSubImage
returns NULL.
.LP
.ZN XGetSubImage
can generate
.ZN BadDrawable ,
.ZN BadGC ,
.ZN BadMatch ,
and
.ZN BadValue 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.TP 1i
.ZN BadGC
A value for a GContext argument does not name a defined GContext.
.TP 1i
.ZN BadMatch
An
.ZN InputOnly
window is used as a Drawable.
.TP 1i
.ZN BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
