/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XCloseDevice(display, device)
 *   Display	*display;
 *   XDevice *device;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCloseDevice	1
char    *TestName = "XCloseDevice";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XCloseDevice function
 */
static Display	*display;
static XDevice *device;


static int 	ValueReturn;

extern ExtDeviceInfo Devs;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCloseDevice-1.(B)");
	report_assertion("A successful call to XCloseDevice closes the requested");
	report_assertion("device.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XCloseDevice to close a device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret==Success)
	    PASS;
	else
	    FAIL;
	Close_Extension_Display();

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	ret;
Window	w;
int devicekeypress;
XEventClass devicekeypressclass;
Display *client1;
XDevice *dev2;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCloseDevice-2.(B)");
	report_assertion("If a device is actively grabbed by a client, a successful");
	report_assertion("call to XCloseDevice releases the active grab.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Actively grab device.");
	report_strategy("Call XCloseDevice to close the device.");
	report_strategy("Try to grab the device from another client.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }

	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;

	device = Devs.Key;
	w = defwin(display);
	DeviceKeyPress(device, devicekeypress, devicekeypressclass);
	XGrabDevice(display, device, w, True, 1, &devicekeypressclass, 
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	XSync (display,0);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}
	dev2 = XOpenDevice(display,Devs.Key->device_id);

	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret==Success)
	    CHECK;
	else
	    FAIL;

	XGrabDevice(client1, dev2, w, True, 1, &devicekeypressclass, 
	    GrabModeAsync, GrabModeAsync, CurrentTime);
	XSync (client1,0);
	if (isdeleted()) {
		delete("Could not set up second grab");
		return;
	}
	else
		CHECK;
	CHECKPASS(3);
        XUngrabDevice(client1, dev2, CurrentTime);
        XSync(client1, 0);
        XCloseDisplay(client1);
	Close_Extension_Display();

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	ret;
Window	w;
int devicekeypress;
XEventClass devicekeypressclass;
Display *client1;
XDevice *dev2;
int Min_KeyCode, Max_KeyCode, numkeys;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCloseDevice-3.(B)");
	report_assertion("If a passive grab is specified by a client for a device a");
	report_assertion("successful call to CloseDevice releases the passive grab.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up a passive grab on a device.");
	report_strategy("Call XCloseDevice to close the device.");
	report_strategy("Set up a passive grab for the same key/modifier combination.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;

	MinMaxKeys (client1, Devs.Key, &Min_KeyCode, &Max_KeyCode, &numkeys);
	device = Devs.Key;
	dev2 = XOpenDevice(client1,Devs.Key->device_id);
	w = defwin(display);
	DeviceKeyPress(device, devicekeypress, devicekeypressclass);
	XGrabDeviceKey(display, device, Min_KeyCode, AnyModifier, NULL,
		w, True, 1, &devicekeypressclass, GrabModeAsync, GrabModeAsync);
	XSync (display,0);

	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret==Success)
	    CHECK;
	else
	    FAIL;

	ret = XGrabDeviceKey(client1, dev2, Min_KeyCode, AnyModifier, NULL,
		w, True, 1, &devicekeypressclass, GrabModeAsync, GrabModeAsync);
	XSync (client1,0);
	if (ret != GrabSuccess){
		report("Could not set up second grab");
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(3);
        XUngrabDevice(client1, dev2, CurrentTime);
        XSync(client1, 0);
        XCloseDisplay(client1);
	Close_Extension_Display();

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	ret, count=0;
Window	w, w2;
XEventClass dkpclass, dkrclass;
int dkp, dkr;
Display *client1;
XDevice *dev2=NULL;
XEvent ev;
int Min_KeyCode, Max_KeyCode, numkeys;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCloseDevice-4.(B)");
	report_assertion("If a device is frozen and events have been enqueued, a");
	report_assertion("successful call to CloseDevice thaws the device and releases");
	report_assertion("the queued events.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set up a passive grab on a device.");
	report_strategy("Call XCloseDevice to close the device.");
	report_strategy("Set up a passive grab for the same key/modifier combination.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
	    {
	    CHECK;
	    count++;
	    }
	MinMaxKeys (client1, Devs.Key, &Min_KeyCode, &Max_KeyCode, &numkeys);
	dev2 = XOpenDevice(client1,Devs.Key->device_id);

	w = defwin(display);
	w2 = defwin(client1);
	warppointer(client1, w2, 1, 1);
	DeviceKeyPress(dev2, dkp, dkpclass);
	DeviceKeyRelease(dev2, dkr, dkrclass);
	XSelectExtensionEvent(client1, w2, &dkpclass, 1);
	XGrabDevice(display, device, w, True, 0, NULL, GrabModeSync, 
	    GrabModeAsync, CurrentTime);
	XSync (display,0);
	XSync (client1,0);
	if (isdeleted()) {
		delete("Could not set up initial grab");
		return;
	}
	if (noext(1))
		return;

	devicekeypress(client1, dev2, Min_KeyCode);
	devicekeyrel(client1, dev2, Min_KeyCode);
	devicekeypress(client1, dev2, Min_KeyCode);
	devicekeyrel(client1, dev2, Min_KeyCode);
	devicekeypress(client1, dev2, Min_KeyCode);
	devicekeyrel(client1, dev2, Min_KeyCode);
	devicekeypress(client1, dev2, Min_KeyCode);
	devicekeyrel(client1, dev2, Min_KeyCode);
	XSync (client1,0);

	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret==Success)
	    {
	    CHECK;
	    count++;
	    }
	else
	    FAIL;

	XSync (client1,0);
	while (XPending(client1)) 
	    {
	    XNextEvent(client1, &ev);
	    if (ev.type==dkp || ev.type==dkr)
		CHECK;
	    else
		FAIL;
	    }
	devicerelkeys(dev2);
	CHECKPASS(count+4);
        XUngrabDevice(client1, dev2, CurrentTime);
        XSync(client1, 0);
        XCloseDisplay(client1);
	Close_Extension_Display();


	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29186 */
/* End of included file Mdefcode.tmc.29186 */

static void t005(){

int 	i,ret;
Window	w;
Display *client1;
XDevice *dev2;
XEventClass dkpclass, dkrclass;
int dkp, dkr;
XEvent ev;
int Min_KeyCode, Max_KeyCode, numkeys;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCloseDevice-5.(B)");
	report_assertion("If more than one client has opened a device, a successful");
	report_assertion("call to CloseDevice does not affect access to the device by");
	report_assertion("other clients.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	if (noext(1))
	    return;
	device = Devs.Key;
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
	MinMaxKeys (client1, Devs.Key, &Min_KeyCode, &Max_KeyCode, &numkeys);
	dev2 = XOpenDevice(client1,Devs.Key->device_id);

	w = defwin(client1);
	warppointer(client1, w, 1, 1);
	DeviceKeyPress(dev2, dkp, dkpclass);
	DeviceKeyRelease(dev2, dkr, dkrclass);
	XSelectExtensionEvent(client1, w, &dkpclass, 1);
	XSync (client1,0);

	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (ret==Success)
	    CHECK;
	else
	    FAIL;

	for (i=0; i<4; i++)
	    {
	    devicekeypress(client1, dev2, Min_KeyCode);
	    devicekeyrel(client1, dev2, Min_KeyCode);
	    }
	XSync (client1,0);

	while (XPending(client1)) 
	    {
	    XNextEvent(client1, &ev);
	    if (ev.type==dkp || ev.type==dkr)
		CHECK;
	    else
		FAIL;
	    }
	devicerelkeys(dev2);
	CHECKPASS(6);
        XCloseDisplay(client1);
	Close_Extension_Display();

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.29186 */
/* End of included file Mdefcode.tmc.29186 */

static void t006(){

XID 	baddevice; 
int	devicekeypress;
XDeviceInfo *list;
int ret, i, j, ndevices, revert, nfeed, mask, ksyms_per;
int nevents, mode, evcount, valuators, min, max, count=0;
Window focus, w;
Time time;
XKbdFeedbackControl feedctl;
KeySym ksyms;
XModifierKeymap *modmap;
unsigned char bmap[8];
XDeviceResolutionControl dctl;
XEventClass devicekeypressclass;
XEvent ev;
XDevice bogus;
XAnyClassPtr any;
int err;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCloseDevice-6.(B)");
	report_assertion("A call to XCloseDevice closes the requested device, causing");
	report_assertion("any subsequent request that requires a Device to fail with a");
	report_assertion("BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XCloseDevice to close a device.");
	report_strategy("Call other input device extension requests.");
	report_strategy("Verify a BadDevice error occurs.");

	tpstartup();
	setargs();

	w = defwin(display);
	list = XListInputDevices (display, &ndevices);
	device = NULL;
	for (i=0; i<ndevices; i++,list++)
	    if (list->use == IsXExtensionDevice) {
		any = (XAnyClassPtr) (list->inputclassinfo);
		for (j=0; j<list->num_classes; j++) {
		    if (any->class == KeyClass) {
			device = XOpenDevice (display, list->id);
			min = ((XKeyInfo *) any)->min_keycode;
			max = ((XKeyInfo *) any)->max_keycode;
			break;
		    }
	    	    any = (XAnyClassPtr) ((char *) any + any->length);
		}
	    }
	if (!device) {
	    untested("required input extension device is not present\n");
	    return;
	}
	bogus.device_id = device->device_id;
	DeviceKeyPress(device, devicekeypress, devicekeypressclass);
	modmap = XGetDeviceModifierMapping(display, device);
	BadDevice (display, baddevice);

	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);				/* close the device */
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync (display,0);
	XSetErrorHandler(error_status);

	device = &bogus;
	XSetDeviceMode(display, device, Absolute);
	XSync (display,0);
	if ((err = geterr()) == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XSetDeviceMode did not return BadDevice\n");
		FAIL;
		}
	XGetDeviceMotionEvents(display, device, CurrentTime, CurrentTime,
	    &nevents, &mode, &evcount);
	XSync (display,0);
	if ((err = geterr()) == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetDeviceMotionEvents did not return BadDevice\n");
		FAIL;
		}

	XChangeKeyboardDevice(display, device);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XChangeKeyboardDevice did not return BadDevice\n");
		FAIL;
		}

	XChangePointerDevice(display, device, 0, 1);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XChangePointerDevice did not return BadDevice\n");
		FAIL;
		}

	XGrabDevice(display, device, w, True, 1, &devicekeypressclass,
	   GrabModeAsync, GrabModeAsync, CurrentTime);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGrabDevice did not return BadDevice\n");
		FAIL;
		}

	XUngrabDevice(display, device, CurrentTime);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XUngrabDevice did not return BadDevice\n");
		FAIL;
		}

	XGrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, 
	   w, True, 0, NULL, GrabModeAsync, GrabModeAsync);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGrabDeviceKey did not return BadDevice\n");
		FAIL;
		}

	XUngrabDeviceKey(display, device, AnyKey, AnyModifier, NULL, w);
	XSync (display,0);

	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XUngrabDeviceKey did not return BadDevice\n");
		FAIL;
		}

	XGrabDeviceButton(display, device, AnyButton, AnyModifier, NULL, 
	   w, True, 0, NULL, GrabModeAsync, GrabModeAsync);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGrabDeviceButton did not return BadDevice\n");
		FAIL;
		}

	XUngrabDeviceButton(display, device, AnyButton, AnyModifier, NULL, w);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XUngrabDeviceButton did not return BadDevice\n");
		FAIL;
		}

	XAllowDeviceEvents(display, device, AsyncAll, CurrentTime);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XAllowDeviceEvents did not return BadDevice\n");
		FAIL;
		}

	XGetDeviceFocus(display, device, &focus, &revert, &time);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetDeviceFocus did not return BadDevice\n");
		FAIL;
		}

	XSetDeviceFocus(display, device, None, RevertToNone, CurrentTime);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XSetDeviceFocus did not return BadDevice\n");
		FAIL;
		}

	XGetFeedbackControl(display, device, &nfeed);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetFeedbackControl did not return BadDevice\n");
		FAIL;
		}

	feedctl.class = KbdFeedbackClass;
	feedctl.percent = 0;
	mask = DvPercent;
	XChangeFeedbackControl(display, device, mask, (XFeedbackControl*) &feedctl);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XChangeFeedbackControl did not return BadDevice\n");
		FAIL;
		}

	XGetDeviceKeyMapping(display, device, min, 1, &ksyms_per);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetDeviceKeyMapping did not return BadDevice\n");
		FAIL;
		}

	XChangeDeviceKeyMapping(display, device, min, 1, &ksyms, 1);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XChangeDeviceKeyMapping did not return BadDevice\n");
		FAIL;
		}

	XGetDeviceModifierMapping(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetDeviceModifierMapping did not return BadDevice\n");
		FAIL;
		}

	XSetDeviceModifierMapping(display, device, modmap);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XSetDeviceModifierMapping did not return BadDevice\n");
		FAIL;
		}

	XGetDeviceButtonMapping(display, device, bmap, 8);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetDeviceButtonMapping did not return BadDevice\n");
		FAIL;
		}

	XSetDeviceButtonMapping(display, device, bmap, 8);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XSetDeviceButtonMapping did not return BadDevice\n");
		FAIL;
		}

	XQueryDeviceState(display, device);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XQueryDeviceState did not return BadDevice\n");
		FAIL;
		}

	XSetDeviceValuators(display, device, &valuators, 0, 1);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XSetDeviceValuators did not return BadDevice\n");
		FAIL;
		}

	XDeviceBell(display, device, 0, 0, 100);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XDeviceBell did not return BadDevice\n");
		FAIL;
		}

	XGetDeviceControl(display, device, DEVICE_RESOLUTION);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XGetDeviceControl did not return BadDevice\n");
		FAIL;
		}

	dctl.length = sizeof(XDeviceResolutionControl);
	dctl.control = DEVICE_RESOLUTION;
	dctl.num_valuators=1;
	dctl.first_valuator=0;
	dctl.resolutions = &valuators;
	XChangeDeviceControl(display, device, DEVICE_RESOLUTION, (XDeviceControl *) &dctl);
	XSync (display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XChangeDeviceControl did not return BadDevice\n");
		FAIL;
		}

	ev.type = devicekeypress;
	XSendExtensionEvent(display, device, PointerWindow, True, 0, NULL,
	    &ev);
	XSync(display,0);
	if (geterr() == baddevice)
		{
		CHECK;
		count++;
		}
	else
		{
		report("XSendExtensionEvent did not return BadDevice\n");
		FAIL;
		}

	XSetErrorHandler(unexp_err);
	CHECKPASS(count);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

XID baddevice;
int ret;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCloseDevice-7.(B)");
	report_assertion("A call to XCloseDevice will fail with a BadDevice error if");
	report_assertion("an invalid device is specified.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	BadDevice (display, baddevice);
	Devs.Key->device_id = -1;
	device = Devs.Key;

	startcall(display);
	if (isdeleted())
		return;
	ret = XCloseDevice(display, device);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
