/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetDeviceFocus(display, device, focus, revert_to, time1)
 *   Display	*display;
 *   XDevice *device;
 *   Window	focus;
 *   int	revert_to;
 *   int	time1;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetDeviceFocus	1
char    *TestName = "XSetDeviceFocus";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW focus
#define A_DRAWABLE focus


/*
 * Arguments to the XSetDeviceFocus function
 */
static Display	*display;
static XDevice *device;
static Window	focus;
static int	revert_to;
static int	time1;


XID baddevice;
extern ExtDeviceInfo Devs;
extern int MinKeyCode;



static char	*WindowTree[]= {
	"toplevel",
		"child1 toplevel (10,10) 30x30",
		"child2 toplevel (50,50) 30x30",
			"grandchild child2 (2,2) 20x20",
};

static int NWindowTree = NELEM(WindowTree);


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	focus = PointerRoot;
	revert_to = RevertToPointerRoot;
	time1 = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetDeviceFocus-1.(B)");
	report_assertion("When a window argument does not name a valid Window,");
	report_assertion("PointerRoot or None, then a BadWindow error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");


	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	focus = badwin(display);
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadWindow)
	    PASS;
	else
	    FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	win;
XEvent	ev;
int	n;
int	dkp, dkr;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetDeviceFocus-2.(B)");
	report_assertion("When the focus argument is None, then all device events are");
	report_assertion("discarded until a new focus window is set.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Create a window and select DeviceKeyPress and DeviceKeyRelease events.");
	report_strategy("  Call XSetDeviceFocus with focus = None.");
	report_strategy("  Warp pointer into window and simulate keypress using extension.");
	report_strategy("  Ensure no event received.");
	report_strategy("  Call XSetDeviceFocus with focus = window.");
	report_strategy("  Simulate key release.");
	report_strategy("  Ensure event now received.");
	report_strategy("else");
	report_strategy("  report untested.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }

	if (noext(0))
		return;
	else
		CHECK;

	device = Devs.Key;
	DeviceKeyPress(device, dkp, classes[0]);
	DeviceKeyRelease(device, dkr, classes[1]);
	win = defwin(display);
	XSelectExtensionEvent(display, win, classes, 2);
	focus = None;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	warppointer(display, win, 2, 2);
	XSync(display, True); /* clear out event queue */
	devicekeypress(display, device, MinKeyCode);
	if (n=getevent(display, &ev)) /* assignment intentional */ {
		report("Got %d events instead of 0, first was type %s.",
			n, eventname(ev.type));
		FAIL;
	} else
		CHECK;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(display, True); /* clear out event queue */
	devicekeyrel(display, device, MinKeyCode);
	if (!XCheckTypedWindowEvent(display, win, dkr, &ev)) {
		report("Normal event processing not restored.");
		FAIL;
	} else
		CHECK;

	devicerelkeys(device);
	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XEvent	ev;
int	dkp, dkr;
XEventClass classes[2];
int	n;
Window	parent,child2,gchild;
Window	windows[6]; /* root + 4 + None stopper */
Window	root;
Window	*wp;
struct buildtree *tree;
char	*wname;
char	*evwname;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetDeviceFocus-3.(B)");
	report_assertion("When the focus argument is a window, then device events");
	report_assertion("that would normally be reported to the focus window or one");
	report_assertion("of its inferiors are reported as usual and all other");
	report_assertion("keyboard events are reported relative to the focus window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Create a window tree and select DeviceKeyPress and DeviceKeyRelease events ");
	report_strategy("  on all.");
	report_strategy("  Call XSetDeviceFocus with focus = window in tree with child (child2, with child");
	report_strategy("    grandchild).");
	report_strategy("  Warp pointer into all windows, and root, and simulate keypress/release using");
	report_strategy("    extension in each.");
	report_strategy("  Ensure event.xany.window is focus (child2) in all cases except grandchild,");
	report_strategy("    when it should be grandchild.");
	report_strategy("  Release any remaining keys.");
	report_strategy("else");
	report_strategy("  report untested.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	DeviceKeyPress(device, dkp, classes[0]);
	DeviceKeyRelease(device, dkr, classes[1]);

	if (noext(0))
		return;
	else
		CHECK;
	wp = windows;
	*wp++ = root = DRW(display);
	*wp++ = parent = defwin(display);
	tree = buildtree(display, parent, WindowTree, NWindowTree);
	*wp++ = btntow(tree, "child1");
	*wp++ = child2 = btntow(tree, "child2");
	*wp++ = gchild = btntow(tree, "grandchild");
	*wp = None;

	for(wp=windows; *wp != None; wp++)
		XSelectExtensionEvent(display, *wp, classes, 2);

	focus = child2;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for(wp=windows; *wp != None; wp++) { /* around 5 times */
		(void)warppointer(display, *wp, 0,0);
		/* use 0,0 as window making stuff keeps away from there on
		 * root. All of our tree windows are not at 0,0 either
		 */
		XSync(display, True); /* clear out event queue */
		devicekeypress(display, device, MinKeyCode);
		devicekeyrel(display, device, MinKeyCode);
		if (!(wname = btwton(tree,*wp)))
			wname = (*wp == root) ? "ROOT" : "<Unknown>";
		if (!(n=XCheckTypedEvent(display, dkp, &ev))) {
			report("No event received after keypress/release in window %s.", (*wp==focus)?"focus":wname);
			FAIL;
		} else
			CHECK;
		if (n && !(evwname = btwton(tree,ev.xany.window)))
			evwname = (ev.xany.window == root) ? "ROOT" :
				((ev.xany.window == None) ? "None" : "<Unknown>");
		if (*wp == focus || *wp == gchild) {
			if (n && ev.xany.window != *wp) {
				report("Event window was %s instead of %s for focus window or child.", evwname, wname);
				FAIL;
			} else
				CHECK;
		} else {
			if (n && ev.xany.window != focus) {
				report("Event window was %s instead of focus window.", evwname);
				FAIL;
			} else
				CHECK;
		}
	}

	devicerelkeys(device);
	CHECKPASS(1+2*5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	win, root, altroot;
XEvent	ev;
int	dkp, dkr;
XEventClass classes[2], nevclass;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetDeviceFocus-4.(B)");
	report_assertion("When the focus argument is PointerRoot, then the focus");
	report_assertion("window is taken to be the root window of the screen the");
	report_assertion("pointer is on at each device event.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If extension available:");
	report_strategy("  Create a toplevel window, select DeviceKeyPress and DeviceKeyRelease events.");
	report_strategy("  Select DeviceKeyPress and DeviceKeyRelease events in root window.");
	report_strategy("  Call XSetDeviceFocus with focus = PointerRoot.");
	report_strategy("  Warp pointer into window and simulate keypress using extension.");
	report_strategy("  Ensure event received and that event.xany.window = window.");
	report_strategy("  Warp pointer into root window.");
	report_strategy("  Simulate key release.");
	report_strategy("  Ensure event received and that event.xany.window = root (focus).");
	report_strategy("  If more than one screen:");
	report_strategy("    Select DeviceKeyPress and DeviceKeyRelease events in root window of ");
	report_strategy("    alternate screen.");
	report_strategy("    Warp pointer into root window of alternate screen.");
	report_strategy("    Simulate KeyPress/KeyRelease.");
	report_strategy("    Ensure event received and that event.xany.window = altroot (focus) and");
	report_strategy("      event.xkey.same_screen is True and event.xkey.root is altroot.");
	report_strategy("  else");
	report_strategy("    Issue incomplete testing message and report untested.");
	report_strategy("else");
	report_strategy("  report untested.");

	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	DeviceKeyPress(device, dkp, classes[0]);
	DeviceKeyRelease(device, dkr, classes[1]);
	NoExtensionEvent(device, unused, nevclass);

	win = defwin(display);
	XSelectExtensionEvent(display, win, classes, 2);
	XSelectExtensionEvent(display, root = DRW(display), classes, 2);
	trace("Test with toplevel window and PointerRoot.");
	focus = PointerRoot;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	warppointer(display, win, 2, 2);
	XSync(display, True); /* clear out event queue */
	devicekeypress(display, device, MinKeyCode);
	if (!getevent(display, &ev)) {
		report("No event received.");
		FAIL;
	} else if (ev.type != dkp && ev.type != dkr) {
		report("First event was of unexpected type: %s.", eventname(ev.type));
		FAIL;
	} else if (ev.xkey.window != win) {
		report("First event had unexpected window: 0x%x instead of 0x%x.",
			(unsigned)ev.xkey.window, (unsigned)win);
		FAIL;
	} else
		CHECK;
	trace("Test with root and PointerRoot.");
	warppointer(display, root, 0,0);
	XSync(display, True); /* clear out event queue */
	devicekeyrel(display, device, MinKeyCode);
	if (!getevent(display, &ev)) {
		report("No event received.");
		FAIL;
	} else if (ev.type != dkp && ev.type != dkr) {
		report("First event was of unexpected type: %s.", eventname(ev.type));
		FAIL;
	} else if (ev.xkey.window != root) {
		report("First event had unexpected window: 0x%x instead of 0x%x.",
			(unsigned)ev.xkey.window, (unsigned)root);
		FAIL;
	} else
		CHECK;

	if (config.alt_screen != -1) {
		altroot = RootWindow(display, config.alt_screen);
		trace("Testing with root of alternate screen as source (0x%x) and PointerRoot.",
				(unsigned)altroot);
		XSelectExtensionEvent(display, altroot, classes, 2);
		warppointer(display, altroot, 0,0);
		XSync(display, True); /* clear out event queue */
		devicekeypress(display, device, MinKeyCode);
		devicekeyrel(display, device, MinKeyCode);

		if (!getevent(display, &ev)) {
			report("No event received.");
			FAIL;
		} else if (ev.type != dkp && ev.type != dkr) {
			report("First event was of unexpected type: %s.", eventname(ev.type));
			FAIL;
		} else if (ev.xkey.window != altroot) {
			report("First event had unexpected window: 0x%x instead of focus (altroot) 0x%x.",
				(unsigned)ev.xkey.window, (unsigned)altroot);
			FAIL;
		} else if (!ev.xkey.same_screen) {
			report("same_screen unexpectedly False.");
			FAIL;
		} else if (ev.xkey.root != altroot) {
			report("First event had unexpected root window: 0x%x instead of 0x%x.",
				(unsigned)ev.xkey.root, (unsigned)altroot);
			FAIL;
		} else
			CHECK;
		CHECKPASS(4);
	} else {
		report("Tested as far as possible with just one screen.");
		CHECKUNTESTED(3);
	XSelectExtensionEvent(display, win, &nevclass, 1);
	XSelectExtensionEvent(display, root, &nevclass, 1);
	devicerelkeys(device);
	}

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	win, sav;
XEvent	ev;
int	n, sav_revert;
int	dkp, dkr;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetDeviceFocus-5.(B)");
	report_assertion("When the focus argument is FollowKeyboard, then the focus");
	report_assertion("window is taken to be the focus window of the X keyboard.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");


	tpstartup();
	setargs();
	if (noext(0))
		return;
	else
		CHECK;

	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Key;
	DeviceKeyPress(device, dkp, classes[0]);
	DeviceKeyRelease(device, dkr, classes[1]);
	win = defwin(display);
	XSelectExtensionEvent(display, win, classes, 2);

	focus = FollowKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSync(display, True); /* clear out event queue */
	devicekeypress(display, device, MinKeyCode);
	if (n=getevent(display, &ev)) /* assignment intentional */ {
		report("Got %d events instead of 0, first was type %s.",
			n, eventname(ev.type));
		FAIL;
	} else
		CHECK;

	XGetInputFocus(display, &sav, &sav_revert);
	XSetInputFocus(display, win, RevertToPointerRoot, CurrentTime);
	XSync(display, True); /* clear out event queue */
	devicekeyrel(display, device, MinKeyCode);
	if (!XCheckTypedWindowEvent(display, win, dkr, &ev)) {
		report("No event received from focus window.");
		FAIL;
	} else
		CHECK;

	XSetInputFocus(display, sav, sav_revert, CurrentTime);
	devicerelkeys(device);
	CHECKPASS(3);


	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Window	base;
XDeviceFocusInEvent	figood;
XDeviceFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
Time	newtime;
int	dfi, dfo;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetDeviceFocus-6.(B)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToParent, then the focus reverts to the");
	report_assertion("closest viewable ancestor of the focus window, the revert_to");
	report_assertion("value is changed to RevertToNone and DeviceFocusIn and");
	report_assertion("DeviceFocusOut events are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToParent.");
	report_strategy("Call XSetDeviceFocus.");
	report_strategy("Enable events on windows.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is the base window.");
	report_strategy("Verify that revert_to is RevertToNone.");
	report_strategy("Verify that Focus events are generated.");

	tpstartup();
	setargs();

	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }

	device = Devs.Focus;
	DeviceFocusIn(device, dfi, classes[0]);
	DeviceFocusOut(device, dfo, classes[1]);
	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToParent;

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectExtensionEvent(display, base, classes, 2);
	XSelectExtensionEvent(display, focus, classes, 2);

	XUnmapWindow(display, focus);
	XGetDeviceFocus(display, device, &newfocus, &newrevert, &newtime);
	if (isdeleted())
		return;

	if (newfocus != base) {
		report("Focus window was 0x%x, expecting 0x%x", newfocus, base);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToNone) {
		report("New revert_to value was %s, expecting RevertToNone",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/*
	 * Event testing. In this case there should be a DeviceFocusOut on the
	 * focus window, followed by a DeviceFocusIn on the base window.
	 */
	defsetevent(fogood, display, dfo);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyAncestor;
	fogood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	defsetevent(figood, display, dfi);
	figood.window = base;
	figood.mode = NotifyNormal;
	figood.detail = NotifyInferior;
	figood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Window	base;
XDeviceFocusInEvent	figood;
XDeviceFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
Time	newtime;
int	dfi, dfo;
XEventClass classes[2], nevclass;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetDeviceFocus-7.(B)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToPointerRoot, then the focus window");
	report_assertion("reverts to PointerRoot and DeviceFocusIn and DeviceFocusOut");
	report_assertion("events are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToPointerRoot.");
	report_strategy("Warp pointer to 0,0 (guaranteed none of our windows are here)");
	report_strategy("Call XSetDeviceFocus.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is PointerRoot.");
	report_strategy("Verify that revert_to is RevertToPointerRoot.");
	report_strategy("Verify that Focus events are generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	DeviceFocusIn(device, dfi, classes[0]);
	DeviceFocusOut(device, dfo, classes[1]);
	NoExtensionEvent(device, unused, nevclass);

	/*
	 * Use a non-default display, because we are setting the event mask
	 * on the root window, which would mess up things for the next tests.
	 */
	display = opendisplay();

	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToPointerRoot;

	warppointer(display, DRW(display), 0, 0);

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectExtensionEvent(display, base, classes, 2);
	XSelectExtensionEvent(display, focus, classes, 2);
	XSelectExtensionEvent(display, DRW(display), classes, 2);

	XUnmapWindow(display, focus);
	XGetDeviceFocus(display, device, &newfocus, &newrevert, &newtime);
	if (isdeleted())
		return;

	if (newfocus != PointerRoot) {
		report("Focus window was 0x%x, expecting 0x%x", newfocus, PointerRoot);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToPointerRoot) {
		report("New revert_to value was %s, expecting RevertToPointerRoot",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/* FocusOut from focus window */
	defsetevent(fogood, display, dfo);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;
	fogood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusOut on the base window */
	fogood.window = base;
	fogood.detail = NotifyNonlinearVirtual;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusOut on the root window */
	fogood.window = DRW(display);

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusIn on the root window */
	defsetevent(figood, display, dfi);
	figood.window = DRW(display);
	figood.mode = NotifyNormal;
	figood.detail = NotifyPointerRoot;
	figood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	figood.window = DRW(display);
	figood.detail = NotifyPointer;

	/* FocusIn for the pointer */
	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;
	
	CHECKPASS(12);
	XSelectExtensionEvent(display, DRW(display), &nevclass, 1);
	XSelectExtensionEvent(display, base, &nevclass, 1);
	XSelectExtensionEvent(display, focus, &nevclass, 1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Window	base;
XDeviceFocusInEvent	figood;
XDeviceFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
Time	newtime;
int	dfi, dfo;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XSetDeviceFocus-8.(B)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToFollowKeyboard, then the focus window");
	report_assertion("reverts to the focus window of the X keyboard, and");
	report_assertion("DeviceFocusIn and DeviceFocusOut events are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToFollowKeyboard.");
	report_strategy("Warp pointer to 0,0 (guaranteed none of our windows are here)");
	report_strategy("Call XSetDeviceFocus.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is the same as the X keyboard focus.");
	report_strategy("Verify that revert_to is RevertToFollowKeyboard.");
	report_strategy("Verify that DeviceFocus events are generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	DeviceFocusIn(device, dfi, classes[0]);
	DeviceFocusOut(device, dfo, classes[1]);

	/*
	 * Use a non-default display, because we are setting the event mask
	 * on the root window, which would mess up things for the next tests.
	 */
	display = opendisplay();

	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToFollowKeyboard;

	warppointer(display, DRW(display), 0, 0);

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectExtensionEvent(display, base, classes, 2);
	XSelectExtensionEvent(display, focus, classes, 2);
	XSelectExtensionEvent(display, DRW(display), classes, 2);

	XUnmapWindow(display, focus);
	XGetDeviceFocus(display, device, &newfocus, &newrevert, &newtime);
	if (isdeleted())
		return;

	if (newfocus != FollowKeyboard) {
		report("Focus window was 0x%x, expecting 0x%x", newfocus, FollowKeyboard);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToFollowKeyboard) {
		report("New revert_to value was %s, expecting RevertToFollowKeyboard",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/* FocusOut from focus window */
	defsetevent(fogood, display, dfo);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;
	fogood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusOut on the base window */
	fogood.window = base;
	fogood.detail = NotifyNonlinearVirtual;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusOut on the root window */
	fogood.window = DRW(display);

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusIn on the root window */
	defsetevent(figood, display, dfi);
	figood.window = DRW(display);
	figood.mode = NotifyNormal;
	figood.detail = NotifyPointerRoot;
	figood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	figood.window = DRW(display);
	figood.detail = NotifyPointer;

	/* FocusIn for the pointer */
	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;
	
	CHECKPASS(12);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Window	base;
XDeviceFocusInEvent	figood;
XDeviceFocusOutEvent	fogood;
XEvent	ev;
Window	newfocus;
int 	newrevert;
Time	newtime;
int	dfi, dfo;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XSetDeviceFocus-9.(B)");
	report_assertion("When the focus window later becomes not viewable and");
	report_assertion("revert_to is RevertToNone, then the focus window reverts to");
	report_assertion("None and DeviceFocusIn and DeviceFocusOut events are");
	report_assertion("generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create base window");
	report_strategy("Create child of this window and set focus argument to it.");
	report_strategy("Set revert_to argument to RevertToNone.");
	report_strategy("Call XSetDeviceFocus.");
	report_strategy("Unmap focus window.");
	report_strategy("Verify that focus is None");
	report_strategy("Verify that revert_to is RevertToNone.");
	report_strategy("Verify that Focus events are generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	DeviceFocusIn(device, dfi, classes[0]);
	DeviceFocusOut(device, dfo, classes[1]);

	/*
	 * Use a non-default display, because we are setting the event mask
	 * on the root window, which would mess up things for the next tests.
	 */
	display = opendisplay();

	base = defwin(display);
	focus = crechild(display, base, (struct area *)0);
	revert_to = RevertToNone;

	warppointer(display, DRW(display), 0, 0);

	if (isdeleted())
		return;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectExtensionEvent(display, base, classes, 2);
	XSelectExtensionEvent(display, focus, classes, 2);
	XSelectExtensionEvent(display, DRW(display), classes, 2);

	XUnmapWindow(display, focus);
	XGetDeviceFocus(display, device, &newfocus, &newrevert, &newtime);
	if (isdeleted())
		return;

	if (newfocus != None) {
		report("Focus window was 0x%x, expecting None", newfocus);
		FAIL;
	} else
		CHECK;

	if (newrevert != RevertToNone) {
		report("New revert_to value was %s, expecting RevertToNone",
			reverttoname(newrevert));
		FAIL;
	} else
		CHECK;

	/* FocusOut from focus window */
	defsetevent(fogood, display, dfo);
	fogood.window = focus;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;
	fogood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusOut on the base window */
	fogood.window = base;
	fogood.detail = NotifyNonlinearVirtual;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusOut on the root window */
	fogood.window = DRW(display);

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;
	
	/* FocusIn on the root window */
	defsetevent(figood, display, dfi);
	figood.window = DRW(display);
	figood.mode = NotifyNormal;
	figood.detail = NotifyDetailNone;
	figood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Window	win;
Window	newfocus;
int 	newrevert;
Time	newtime;
int	dfi, dfo;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XSetDeviceFocus-10.(B)");
	report_assertion("When the specified time is earlier than the current last-");
	report_assertion("focus-change time or is later than the current X server");
	report_assertion("time, then a call to XSetDeviceFocus has no effect.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create window.");
	report_strategy("Get current X server time with gettime().");
	report_strategy("Set focus to None using this time.");
	report_strategy("");
	report_strategy("Attempt to set the focus window with a time less than the previous time.");
	report_strategy("Verify that focus is still None.");
	report_strategy("");
	report_strategy("Get current time again.");
	report_strategy("Add amount to get time in the future.");
	report_strategy("Attempt to set the focus window with this time.");
	report_strategy("Verify that focus is still None.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	DeviceFocusIn(device, dfi, classes[0]);
	DeviceFocusOut(device, dfo, classes[1]);

	win = defwin(display);

	time1 = gettime(display);
	focus = None;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	time1 -= 12;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetDeviceFocus(display, device, &newfocus, &newrevert, &newtime);
	if (newfocus == None)
		CHECK;
	else {
		report("Focus was changed when time was earlier than last-focus-change time");
		FAIL;
	}

	time1 = gettime(display);
	time1 += ((config.speedfactor+1) * 1000000);

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetDeviceFocus(display, device, &newfocus, &newrevert, &newtime);
	if (newfocus == None)
		CHECK;
	else {
		report("Focus was changed when time was later than current X server time");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Time	t1,t2;
Window	win;
Window	focus_return;
int	junk;
Time	junk2;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XSetDeviceFocus-11.(A)");
	report_assertion("A successful call to XSetDeviceFocus sets the");
	report_assertion("last-focus-change time to the specified time with");
	report_assertion("CurrentTime being replaced by the current X server time.");

	report_strategy("Create toplevel window.");
	report_strategy("Call XSetDeviceFocus with time = gettime(display) and focus = window.");
	report_strategy("Call XGetInputFocus and verify that focus_return is window.");
	report_strategy("Attempt XSetDeviceFocus at time just before time with focus = root.");
	report_strategy("Check focus is still window.");
	report_strategy("Attempt XSetDeviceFocus at time equal to time and focus = root.");
	report_strategy("Check focus is now root.");
	report_strategy("");
	report_strategy("Get time before with gettime(display).");
	report_strategy("Call XSetDeviceFocus with time = CurrentTime and focus = window.");
	report_strategy("Call XGetInputFocus and verify that focus_return is window.");
	report_strategy("Attempt XSetDeviceFocus at time before with focus = root.");
	report_strategy("Check focus is still window.");
	report_strategy("Attempt XSetDeviceFocus at CurrentTime and focus = root.");
	report_strategy("Check focus is now root.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	win = defwin(display);
	XSync(display, True);
	t1 = gettime(display);
	if (t1 == CurrentTime) {
		delete("Could not get server time.");
		return;
	} else
		CHECK;

	time1 = t1;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != win) {
		report("Failed to change focus with time = 0x%lx.", (unsigned long)time1);
		FAIL;
	} else
		CHECK;
	trace("Focus set at time 0x%lx.",(unsigned long)time1);
	time1--;
	focus = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != win) {
		report("Last focus change time set earlier than specified time.");
		FAIL;
	} else
		CHECK;
	time1 = t1;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != focus) {
		report("Last focus change time set later than specified time.");
		FAIL;
	} else
		CHECK;

	/* last despairing attempt */
	time1 = CurrentTime;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != focus) {
		delete("Cannot restore focus to perform CurrentTime tests.");
		return;
	} else
		CHECK;

	XSync(display, True);
	t1 = gettime(display);
	if (t1 == CurrentTime) {
		delete("Could not get earlier server time.");
		return;
	} else
		CHECK;

	time1 = CurrentTime;
	focus = win;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != focus) {
		delete("Failed to change focus at CurrentTime.");
		return;
	} else
		CHECK;
	/* now set up OK */
	t2 = gettime(display);
	if (t2 == CurrentTime) {
		delete("Could not get later server time.");
		return;
	} else
		CHECK;

	trace("Focus changed at time between 0x%lx and 0x%lx (diff = %d).",t1,t2,t2-t1);
	time1 = t1;
	focus = DRW(display);
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != win) {
		report("Last focus change time set earlier than 0x%lx.",t1);
		FAIL;
	} else
		CHECK;
	time1 = t2;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &focus_return, &junk, &junk2);
	if (focus_return != focus) {
		report("Last focus change time set later than 0x%lx.", t2);
		FAIL;
	} else
		CHECK;

	CHECKPASS(10);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Window	base;
Window	ch1;
Window	ch2;
struct	area	area;
XDeviceFocusInEvent	figood;
XDeviceFocusOutEvent	fogood;
XEvent	ev;
int	dfi, dfo;
XEventClass classes[2];
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XSetDeviceFocus-12.(B)");
	report_assertion("When the focus changes, then DeviceFocusIn and");
	report_assertion("DeviceFocusOut events are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create base window.");
	report_strategy("Create two subwindows on base.");
	report_strategy("Set focus to first subwindow.");
	report_strategy("Enable events on all three windows.");
	report_strategy("Call XSetDeviceFocus to change focus to second subwindow.");
	report_strategy("Verify that focus events are generated.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	DeviceFocusIn(device, dfi, classes[0]);
	DeviceFocusOut(device, dfo, classes[1]);

	base = defwin(display);
	setarea(&area, 0, 0, 2, 2);
	ch1 = crechild(display, base, &area);
	setarea(&area, 20, 20, 2, 2);
	ch2 = crechild(display, base, &area);

	focus = ch1;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectExtensionEvent(display, ch1, classes, 2);
	XSelectExtensionEvent(display, ch2, classes, 2);
	XSelectExtensionEvent(display, base, classes, 2);

	focus = ch2;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* FocusOut from old focus window, ch1 */
	defsetevent(fogood, display, dfo);
	fogood.window = ch1;
	fogood.mode = NotifyNormal;
	fogood.detail = NotifyNonlinear;
	fogood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfo) {
		report("Was expecting a DeviceFocusOut event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&fogood, &ev))
		FAIL;
	else
		CHECK;

	/* FocusIn on the new focus window, ch2 */
	defsetevent(figood, display, dfi);
	figood.window = ch2;
	figood.mode = NotifyNormal;
	figood.detail = NotifyNonlinear;
	figood.deviceid = device->device_id;

	if (getevent(display, &ev) == 0 || ev.type != dfi) {
		report("Was expecting a DeviceFocusIn event");
		FAIL;
	} else
		CHECK;

	if (checkevent((XEvent*)&figood, &ev))
		FAIL;
	else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Window	base;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XSetDeviceFocus-13.(A)");
	report_assertion("When the specified focus window is not viewable, then a");
	report_assertion("BadMatch error occurs.");

	report_strategy("Create unmapped window.");
	report_strategy("Attempt to set focus to it.");
	report_strategy("Verify that a BadMatch error occurs.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	base = defwin(display);
	focus = creunmapchild(display, base, (struct area *)0);

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;	/* Already done */
	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XSetDeviceFocus-14.(B)");
	report_assertion("When the value of revert_to is other than RevertToParent,");
	report_assertion("RevertToPointerRoot, RevertToFollowKeyboard or RevertToNone,");
	report_assertion("then a BadValue error occurs.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set the revert_to argument to an invalid value.");
	report_strategy("Verify BadValue is returned.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	revert_to = -1;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}
	if (geterr() != BadValue)
	    FAIL;
	else
	    PASS;


	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

Window w, nfocus;
int nrevert;
Time ntime;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XSetDeviceFocus-15.(B)");
	report_assertion("A call to SetDeviceFocus changes the device focus window to");
	report_assertion("that specified in the focus argument.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Touch test.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &nfocus, &nrevert, &ntime);
	if (focus == nfocus && revert_to == nrevert)
	    CHECK;
	else
	    {
	    report("Couldn't set focus to PointerRoot\n");
	    FAIL;
	    }

	focus = None;
	revert_to = RevertToNone;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &nfocus, &nrevert, &ntime);
	if (focus == nfocus && revert_to == nrevert)
	    CHECK;
	else
	    {
	    report("Couldn't set focus to None.\n");
	    FAIL;
	    }

	focus = FollowKeyboard;
	revert_to = RevertToFollowKeyboard;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &nfocus, &nrevert, &ntime);
	if (focus == nfocus && revert_to == nrevert)
	    CHECK;
	else
	    {
	    report("Couldn't set focus to FollowKeyboard.\n");
	    FAIL;
	    }

	w = defwin(display);
	focus = w;
	revert_to = RevertToParent;
	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XGetDeviceFocus(display, device, &nfocus, &nrevert, &ntime);
	if (focus == nfocus && revert_to == nrevert)
	    CHECK;
	else
	    {
	    report("Couldn't set focus to a window.\n");
	    FAIL;
	    }
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t016(){

XDevice nodevice;
int ximajor, first, err;
int 	pass = 0, fail = 0;

 	report_purpose(16);

	report_assertion("Assertion XSetDeviceFocus-16.(B)");
	report_assertion("A call to XSetDeviceFocus specifying an invalid device");
	report_assertion("results in a BadDevice error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid device.");

	tpstartup();
	setargs();
	if (!XQueryExtension (display, INAME, &ximajor, &first, &err)) {
	    untested("%s: Input extension not supported.\n", TestName);
	    return;
	    }

	BadDevice (display, baddevice);
	nodevice.device_id = -1;
	device = &nodevice;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t017(){

int 	pass = 0, fail = 0;

 	report_purpose(17);

	report_assertion("Assertion XSetDeviceFocus-17.(B)");
	report_assertion("A call to XSetDeviceFocus specifying an invalid revert-to");
	report_assertion("mode results in a BadValue error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Make the call with an invalid revert-to mode.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(FocusMask))
	    {
	    untested("%s: No input extension device to focus.\n", TestName);
	    return;
	    }
	device = Devs.Focus;
	revert_to = -1;

	startcall(display);
	if (isdeleted())
		return;
	XSetDeviceFocus(display, device, focus, revert_to, time1);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
