/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_MapNotify	1
char    *TestName = "MapNotify";



#define	EVENT		MapNotify
#define	MASK		StructureNotifyMask
#define	MASKP		SubstructureNotifyMask

int 	tet_thistest;

static void t001(){

Display	*display = Dsp;
Display	*client2;
Window	child;
Window	parent;
XEvent	event_return;
XMapEvent good;
struct area area;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion MapNotify-1.(A)");
	report_assertion("When a window's state changes from unmapped to mapped as a");
	report_assertion("result of save-set processing, then a MapNotify event is");
	report_assertion("generated.");

	report_strategy("Create client2.");
	report_strategy("Create parent window with client2.");
	report_strategy("Create child window as inferior to parent.");
	report_strategy("Add child window to client2's save-set.");
	report_strategy("Set client2's shut down mode to DestroyAll.");
	report_strategy("Select for MapNotify events on child.");
	report_strategy("Call XCloseDisplay with client2.");
	report_strategy("Verify that a MapNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");

	tpstartup();
/* Create client2. */
	if (config.display == (char *) NULL) {
		delete("config.display not set");
		return;
	}
	else
		CHECK;
	client2 = XOpenDisplay(config.display);
	if (client2 == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
/* Create parent window with client2. */
	/* must avoid resource registration! */
	parent = XCreateSimpleWindow(display, DRW(display), 1, 1, W_STDWIDTH, W_STDHEIGHT, 1, 0L, 0L);
	XSync(client2, True);
/* Create child window as inferior to parent. */
	area.x = 1;
	area.y = 1;
	area.width = W_STDWIDTH/2;
	area.height = W_STDHEIGHT/2;
	child = mkwinchild(display, (XVisualInfo *) NULL, &area, False, parent, 1);
	XSync(display, True);
/* Add child window to client2's save-set. */
	XAddToSaveSet(client2, child);
/* Set client2's shut down mode to DestroyAll. */
	XSetCloseDownMode(client2, DestroyAll);
/* Select for MapNotify events on child. */
	XSelectInput(display, child, MASK);
/* Call XCloseDisplay with client2. */
	XSync(display, True);
	XSync(client2, True);
	XCloseDisplay(client2);
	sleep(config.speedfactor);
	XSync(display, False);
/* Verify that a MapNotify event was delivered. */
	if (!XCheckTypedWindowEvent(display, child, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
/* Verify that event member fields are correctly set. */
	good = event_return.xmap;
	good.type = EVENT;
	good.event = child;
	good.window = child;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*display = Dsp;
Display	*client2;
Display	*client3;
Window	w;
int	count;
XEvent	event_return;
XMapEvent good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion MapNotify-2.(A)");
	report_assertion("When a MapNotify event is generated, then all clients");
	report_assertion("having set StructureNotifyMask event mask bits on the mapped");
	report_assertion("window are delivered a MapNotify event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Select for MapNotify events using StructureNotifyMask.");
	report_strategy("Select for MapNotify events using StructureNotifyMask with client2.");
	report_strategy("Select for no events with client3.");
	report_strategy("Generate MapNotify event.");
	report_strategy("Verify that a MapNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that a MapNotify event was delivered to client2.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select for MapNotify events using StructureNotifyMask. */
	XSelectInput(display, w, MASK);
/* Select for MapNotify events using StructureNotifyMask with client2. */
	XSelectInput(client2, w, MASK);
/* Select for no events with client3. */
	XSelectInput(client3, w, NoEventMask);
/* Generate MapNotify event. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XMapWindow(display, w);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that a MapNotify event was delivered. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(display, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xmap;
	good.type = EVENT;
	good.event = w;
	good.window = w;
	good.override_redirect = config.debug_override_redirect;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;
/* Verify that a MapNotify event was delivered to client2. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(client2, w, EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xmap;
	good.type = EVENT;
	good.event = w;
	good.window = w;
	good.override_redirect = config.debug_override_redirect;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event for client2");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;
	
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Display	*display = Dsp;
Display	*client2;
Display	*client3;
Window	w;
int	count;
XEvent	event_return;
XMapEvent good;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion MapNotify-3.(A)");
	report_assertion("When a MapNotify event is generated, then all clients");
	report_assertion("having set SubstructureNotifyMask event mask bits on the");
	report_assertion("parent of the mapped window are delivered a MapNotify event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Select for MapNotify events using SubstructureNotifyMask.");
	report_strategy("Select for MapNotify events using SubstructureNotifyMask with client2.");
	report_strategy("Select for no events with client3.");
	report_strategy("Generate MapNotify event.");
	report_strategy("Verify that a MapNotify event was delivered.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that a MapNotify event was delivered to client2.");
	report_strategy("Verify that event member fields are correctly set.");
	report_strategy("Verify that no events were delivered to client3.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Create window. */
	w = mkwin(display, (XVisualInfo *) NULL, (struct area *) NULL, False);
/* Select for MapNotify events using SubstructureNotifyMask. */
	XSelectInput(display, DRW(display), MASKP);
/* Select for MapNotify events using SubstructureNotifyMask with client2. */
	XSelectInput(client2, DRW(display), MASKP);
/* Select for no events with client3. */
	XSelectInput(client3, DRW(display), NoEventMask);
/* Generate MapNotify event. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XMapWindow(display, w);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that a MapNotify event was delivered. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(display, DRW(display), EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xmap;
	good.type = EVENT;
	good.event = DRW(display);
	good.window = w;
	good.override_redirect = config.debug_override_redirect;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event");
		FAIL;
	}
	else
		CHECK;
/* Verify that a MapNotify event was delivered to client2. */
/* Verify that event member fields are correctly set. */
	if (!XCheckTypedWindowEvent(client2, DRW(display), EVENT, &event_return)) {
		report("Expected %s event, got none", eventname(EVENT));
		FAIL;
	}
	else
		CHECK;
	good = event_return.xmap;
	good.type = EVENT;
	good.event = DRW(display);
	good.window = w;
	good.override_redirect = config.debug_override_redirect;
	if (checkevent((XEvent *) &good, &event_return)) {
		report("Unexpected values in delivered event for client2");
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were delivered to client3. */
	count = XPending(client3);
	if (count != 0) {
		report("Got %d events, expected %d for client3", count, 0);
		FAIL;
		return;
	}
	else
		CHECK;
	
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){


 	report_purpose(4);

	report_assertion("Assertion MapNotify-4.(-)");
	report_assertion("When a MapNotify event is generated, then clients not");
	report_assertion("having set StructureNotifyMask event mask bits on the mapped");
	report_assertion("window and also not having set SubstructureNotifyMask event");
	report_assertion("mask bits on the parent of the mapped window are not");
	report_assertion("delivered a MapNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
