/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XDisplayKeycodes(display, min_keycodes_return, max_keycodes_return)
 *   Display	*display;
 *   int 	*min_keycodes_return;
 *   int 	*max_keycodes_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XDisplayKeycodes	1
char    *TestName = "XDisplayKeycodes";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XDisplayKeycodes function
 */
static Display	*display;
static int 	*min_keycodes_return;
static int 	*max_keycodes_return;



static	int 	Minkc;
static	int 	Maxkc;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	min_keycodes_return = &Minkc;
	max_keycodes_return = &Maxkc;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Window	win;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XDisplayKeycodes-1.(A)");
	report_assertion("A call to XDisplayKeycodes returns the minimum KeyCode");
	report_assertion("value supported by the specified display to");
	report_assertion("min_keycodes_return and the maximum KeyCode value supported");
	report_assertion("by the specified display to max_keycodes_return.");

	report_strategy("Call XDisplayKeycodes.");
	report_strategy("Use min keycode with XGrabKey.");
	report_strategy("Verify that it gives no error.");
	report_strategy("Use min keycode minus one with XGrabKey.");
	report_strategy("Verify that it gives an error.");
	report_strategy("Use max keycode with XGrabKey.");
	report_strategy("Verify that it gives no error.");
	report_strategy("Use max keycode plus one with XGrabKey.");
	report_strategy("Verify that it gives an error.");

	tpstartup();
	setargs();
	win = defwin(display);

	startcall(display);
	if (isdeleted())
		return;
	XDisplayKeycodes(display, min_keycodes_return, max_keycodes_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	trace("Min keycode=%d, max keycode = %d", Minkc, Maxkc);

	/*
	 * Grab key was chosen to test the validity of the keycodes
	 * on the basis that it does no damage to the current setup.
	 */
	CATCH_ERROR(display);
	XGrabKey(display, Minkc, 0, win, False, GrabModeAsync, GrabModeAsync);
	RESTORE_ERROR(display);
	if (GET_ERROR(display) == Success)
		CHECK;
	else {
		report("Minimum keycode value did not appear to be valid");
		report("A %s error occurred using the keycode with XGrabKey",
							errorname(geterr()));
		FAIL;
	}

	CATCH_ERROR(display);
	XGrabKey(display, Minkc-1, 0, win, False, GrabModeAsync, GrabModeAsync);
	RESTORE_ERROR(display);
	if (GET_ERROR(display) != Success) {
		CHECK;
		debug(1, "A %s error occurred using the keycode with XGrabKey",
							errorname(geterr()));
	} else {
		report("Minimum keycode value did not appear to be the lowest valid code");
		report("No error occurred using the keycode with XGrabKey");
		FAIL;
	}

	CATCH_ERROR(display);
	XGrabKey(display, Maxkc, 0, win, False, GrabModeAsync, GrabModeAsync);
	RESTORE_ERROR(display);
	if (GET_ERROR(display) == Success)
		CHECK;
	else {
		report("Maximum keycode value did not appear to be valid");
		report("A %s error occurred using the keycode with XGrabKey",
							errorname(geterr()));
		FAIL;
	}

	if (Maxkc < 255) {
		CATCH_ERROR(display);
		XGrabKey(display, Maxkc+1, 0, win, False, GrabModeAsync, GrabModeAsync);
		RESTORE_ERROR(display);
		if (GET_ERROR(display) != Success) {
			CHECK;
			debug(1, "A %s error occurred using the keycode with XGrabKey",
								errorname(geterr()));
		} else {
			report("Maximum keycode value did not appear to be the highest valid code");
			report("No error occurred using the keycode with XGrabKey");
			FAIL;
		}
	} else 
		CHECK;

	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XDisplayKeycodes-2.(A)");
	report_assertion("A call to XDisplayKeycodes returns a minimum KeyCode value");
	report_assertion("greater than or equal to 8.");

	report_strategy("Call XDisplayKeycodes.");
	report_strategy("Verify minimum KeyCode is greater than or equal to 8.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	XDisplayKeycodes(display, min_keycodes_return, max_keycodes_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (*min_keycodes_return >= 8)
		CHECK;
	else {
		report("Minimum keycode was not greater than or equal to 8, was %d",
			*min_keycodes_return);
		FAIL;
	}
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XDisplayKeycodes-3.(A)");
	report_assertion("A call to XDisplayKeycodes returns a maximum KeyCode value");
	report_assertion("less than or equal to 255.");

	report_strategy("Call XDisplayKeycodes.");
	report_strategy("Verify maximum KeyCode is less than or equal to 255.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	XDisplayKeycodes(display, min_keycodes_return, max_keycodes_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (*max_keycodes_return <= 255)
		CHECK;
	else {
		report("Maximum keycode was not less than or equal to 255, was %d",
			*max_keycodes_return);
		FAIL;
	}
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
