/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* 
* Copyright (c) 1993  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* Copyright 1993 by Sun Microsystems, Inc. Mountain View, CA.
* 
* All Rights Reserved
* 
* Permission  to  use,  copy,  modify,  and  distribute   this
* software  and  its documentation for any purpose and without
* fee is hereby granted, provided that the above copyright no-
* tice  appear  in all copies and that both that copyright no-
* tice and this permission notice appear in  supporting  docu-
* mentation,  and  that the names of Sun or MIT not be used in
* advertising or publicity pertaining to distribution  of  the
* software  without specific prior written permission. Sun and
* M.I.T. make no representations about the suitability of this
* software for any purpose. It is provided "as is" without any
* express or implied warranty.
* 
* SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
* NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
* ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
* ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
* PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
* OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
* THE USE OR PERFORMANCE OF THIS SOFTWARE.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XmbLookupString(ic, event, buffer_return, bytes_buffer, keysym_return, status_return)
 *   XIC ic;
 *   XKeyPressedEvent *event;
 *   char *buffer_return;
 *   int bytes_buffer;
 *   KeySym *keysym_return;
 *   Status *status_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;

#include <locale.h>
#include <ximtest.h>



#define T_XmbLookupString	1
char    *TestName = "XmbLookupString";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XmbLookupString function
 */
static XIC ic;
static XKeyPressedEvent *event;
static char *buffer_return;
static int bytes_buffer;
static KeySym *keysym_return;
static Status *status_return;


static int 	ValueReturn;

static KeySym which_key = 0x062; /* XK_b */
static KeySym which_keycap = 0x042; /* XK_B */

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	ic = 0;
	event = 0;
	buffer_return = 0;
	bytes_buffer = 0;
	keysym_return = 0;
	status_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
char *plocale;
XrmDatabase db = NULL;
XIM im = NULL;
Window win;
XFontSet fs = NULL;
int nstyles = 0;
XIMStyle which_style;
KeyCode kc;
XKeyEvent ke;
KeySym ks=0;
char buf[32];
int mlen;
Status status;
int res,cmplen;
#endif
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XmbLookupString-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XmbLookupString shall return the string from the input");
	report_assertion("method specified in the buffer_return argument. If no string");
	report_assertion("is returned the buffer_return argument shall remain");
	report_assertion("unchanged. The KeySym into which the KeyCode from the event");
	report_assertion("was mapped shall be returned in the keysym_return argument");
	report_assertion("if it is non-NULL and the status_return argument indicates");
	report_assertion("that a KeySym was returned. If both a string and a KeySym");
	report_assertion("are returned, the KeySym value does not necessarily");
	report_assertion("correspond to the string returned. XmbLookupString returns");
	report_assertion("the length of the string in bytes. The text is returned in");
	report_assertion("the encoding of the locale bound to the input method of the");
	report_assertion("specified input context, ic.");

	report_strategy("For all locales, create an input method and ");
	report_strategy("for all supported styles create an input context,");
	report_strategy("Obtain the keycode corresponding to the keysym XK_b using XKeysymToKeycode.");
	report_strategy("Obtain the string and keysym bound to that keycode using XmbLookupString.");
	report_strategy("Verify that the returned string is correct.");
	report_strategy("Obtain the string and keysym bound to that keycode using XmbLookupString with state = ShiftMask.");
	report_strategy("Verify that the returned string is correct.");

	tpstartup();
	setargs();
#if XT_X_RELEASE > 4

	XrmInitialize();

	strcpy(buf,"Xtest uninitialiased string.");
	mlen = strlen(buf);

	resetlocale();
	while(nextlocale(&plocale))
	{

		if (locale_set(plocale))
			CHECK;
		else
		{
			report("Couldn't set locale.");
			FAIL;
			continue;
		}

		cleanup_locale(NULL,fs,im,db);

		db = rm_db_open();
		if(db != NULL)
			CHECK;
		else
		{
			report("Couldn't open database.");
			FAIL;
			continue;
		}

		im = im_open(db);
		if(im != NULL)
			CHECK;
		else
		{
			report("Couldn't open input method.");
			FAIL;
			continue;
		}

     	if(ic_setup(&win,&fs))
			CHECK;
		else
     	{
			report("Couldn't setup input styles.");
			FAIL;
			continue;	
		}

     	reset_ic_style(im);
		nstyles += n_ic_styles();
     	while(next_ic_style(&which_style))
    	{
	  		ic = ic_open(im,win,which_style);
    		if(ic != NULL)
				CHECK;
			else
     		{
	     		report("Unable to create input context for locale, %s",
              			plocale);
        		FAIL;
        		continue;
     		}

			kc = XKeysymToKeycode(Dsp, which_key);

			ke.type = KeyPress;
			ke.display = Dsp;
			ke.keycode = kc;
			ke.state = 0;
			ke.window = win;

			event = &ke;
			buffer_return = (char *) buf;
			bytes_buffer = mlen;
			keysym_return = &ks;
			status_return = &status;

			startcall(Dsp);
			if (isdeleted())
				return;
			res = XmbLookupString(ic, event, buffer_return, bytes_buffer, keysym_return, status_return);
			endcall(Dsp);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			trace("Status = %d\n",status);
			if(ks != which_key)
			{
				report("%s() returned keysym %d instead of %d.", 
					TestName, (int) ks, which_key);
				FAIL;
			}
			else
				CHECK;

			if(res != 1)
			{
				report("%s() returned %d instead of 1.", TestName, res);
				FAIL;
			}
			else
				CHECK;

			cmplen = mlen;
			if(res>0 && res<mlen) cmplen = res;
			buf[cmplen] = '\0';

			if(strncmp(buffer_return, "b", cmplen) != 0)
			{
				report("%s() returned string \"%s\" instead of \"%s\".",
					TestName, buffer_return,"b");
				FAIL;
			}
			else
				CHECK;

			ke.state = ShiftMask;
			event = &ke;
			startcall(Dsp);
			if (isdeleted())
				return;
			res = XmbLookupString(ic, event, buffer_return, bytes_buffer, keysym_return, status_return);
			endcall(Dsp);
			if (geterr() != Success) {
				report("Got %s, Expecting Success", errorname(geterr()));
				FAIL;
			}
			trace("Status = %d\n",status);

			if(ks != which_keycap)
			{
				report("%s() returned keysym %d instead of %d.",
					TestName, (int) ks, which_keycap);
				FAIL;
			}
			else
				CHECK;

			cmplen = mlen;
			if(res>0 && res<mlen) cmplen = res;
			buf[cmplen] = '\0';

			if(strncmp(buffer_return, "B", cmplen) != 0)
			{
				report("%s() returned string \"%s\" instead of \"%s\".",
					TestName, buffer_return,"B");
				FAIL;
			}
			else
				CHECK;

     		ic_close(ic);
        	}
	}   /* nextlocale */
 	cleanup_locale(NULL,fs,im,db);

	CHECKPASS(4*nlocales()+6*nstyles);
#else

	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28153 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XmbLookupString-2.(D)");
	report_assertion("If the implementation is X11R5 or later: If the input");
	report_assertion("string to be returned is too large for the supplied");
	report_assertion("buffer_return XmbLookupString shall return XBufferOverflow");
	report_assertion("in the status_return argument.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28153 */

/* Including from file Mdefcode.tmc.28153 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XmbLookupString-3.(D)");
	report_assertion("If the implementation is X11R5 or later: If no consistent");
	report_assertion("input has been composed so far the value, XLookupNone, shall");
	report_assertion("be returned in status_return and the contents of");
	report_assertion("buffer_return and keysym_return are not modified and");
	report_assertion("XmbLookupString returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28153 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = localestartup;
void	(*tet_cleanup)() = localecleanup;
