/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XWithdrawWindow(display, w, screen_number)
 *   Display		*display;
 *   Window		w;
 *   int		screen_number;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XWithdrawWindow	1
char    *TestName = "XWithdrawWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XWithdrawWindow function
 */
static Display		*display;
static Window		w;
static int		screen_number;


static int 	StatusReturn;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = DRW(Dsp);
	screen_number = DefaultScreen(Dsp);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int			nevents;
XVisualInfo		*vp;
XWindowAttributes	atts;
XEvent			ev;
XEvent			rev;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XWithdrawWindow-1.(A)");
	report_assertion("A call to XWithdrawWindow unmaps the window specified by");
	report_assertion("the w argument and sends, to the root window of the screen");
	report_assertion("specified by the screen_number argument, a synthetic");
	report_assertion("UnmapNotify event with a window of w, an event equal to the");
	report_assertion("receiving root window and a from_configure element of False");
	report_assertion("using an event mask of SubstructureRedirectMask|");
	report_assertion("SubstructureNotifyMask and returns non-zero.");

	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Select UnmapNotify events on the root using XSelectInput with SubstructureNotifyMask.");
	report_strategy("Unmap the window using XWithdrawWindow.");
	report_strategy("Verify that the window is unmapped using XGetWindowAttributes.");
	report_strategy("Verify that a non-synthetic UnmapNotify event is generated.");
	report_strategy("Verify that a synthetic UnmapNotify event is generated.");
	report_strategy("");
	report_strategy("Create a window using XCreateWindow.");
	report_strategy("Select UnmapNotify events on the root using XSelectInput with SubstructureRedirectMask.");
	report_strategy("Unmap the window using XWithdrawWindow.");
	report_strategy("Verify that the window is unmapped using XGetWindowAttributes.");
	report_strategy("Verify that a non-synthetic UnmapNotify event is generated.");

	tpstartup();
	setargs();

	resetvinf(VI_WIN);
	nextvinf(&vp);

	ev.type = UnmapNotify;
	ev.xany.display = display;
	ev.xunmap.type = UnmapNotify;
	ev.xunmap.send_event = False;
	ev.xunmap.display = display;
	ev.xunmap.event = DRW(display);
	ev.xunmap.from_configure = False;

	CATCH_ERROR(display);
	XSelectInput(display, DRW(display), SubstructureNotifyMask);
	RESTORE_ERROR(display);

	if(GET_ERROR(display) != Success) {
		delete("XSelectInput() failed with an event mask of 0x%lx.", SubstructureNotifyMask);
		return;
	} else
		CHECK;

	w = makewin(display, vp);
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XWithdrawWindow(display, w, screen_number);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	
	if(XGetWindowAttributes(display, w, &atts) == False){
		delete("XGetWindowAttributes Failed on window id %lx.", (long) w);
		return;
	} else
		CHECK;
	
	if(atts.map_state != IsUnmapped) {
		report("Window ID %lx was not unmapped", (long) w);
		FAIL;
	} else
		CHECK;
	
	ev.xunmap.window = w;
	ev.xunmap.send_event = False;
	rev.type = -1;
	if( (nevents = getevent(display, &rev)) == 0 ) {
		report("No event was generated.");
		FAIL;
	} else {
		CHECK;
		if( checkevent(&ev, &rev) != 0 )
			FAIL;
		else
			CHECK;
	}
	
	ev.xunmap.send_event = True;
	rev.type = -1;

	if( (nevents = getevent(display, &rev)) == 0 ) {
		report("No event was generated.");
		FAIL;
	} else {
		CHECK;
		if( checkevent(&ev, &rev) != 0 )
			FAIL;
		else
			CHECK;
	}

	CATCH_ERROR(display);
	XSelectInput(display, DRW(display), SubstructureRedirectMask);
	RESTORE_ERROR(display);

	if(GET_ERROR(display) != Success) {
		delete("XSelectInput() failed with an event mask of 0x%lx.",SubstructureRedirectMask);
		return;
	} else
		CHECK;

	w = makewin(display, vp);
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XWithdrawWindow(display, w, screen_number);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	
	if(XGetWindowAttributes(display, w, &atts) == False){
		delete("XGetWindowAttributes Failed on window id %lx.", (long) w);
		return;
	} else
		CHECK;
	
	if(atts.map_state != IsUnmapped) {
		report("Window ID %lx was not unmapped", (long) w);
		FAIL;
	} else
		CHECK;
	
	ev.xunmap.window = w;
	ev.xunmap.send_event = False;
	rev.type = -1;
	if( (nevents = getevent(display, &rev)) == 0 ) {
		report("No event was generated.");
		FAIL;
	} else {
		CHECK;
		if( checkevent(&ev, &rev) != 0 )
			FAIL;
		else
			CHECK;
	}
	
	CHECKPASS(12);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28419 */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XWithdrawWindow-2.(B)");
	report_assertion("When the UnmapNotify event is not successfully sent, then");
	report_assertion("XWithdrawWindow returns zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28419 */

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XWithdrawWindow-3.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XWithdrawWindow(display, w, screen_number);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
