/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XParseGeometry(parsestring, x_return, y_return, width_return, height_return)
 *   char	*parsestring;
 *   int	*x_return;
 *   int	*y_return;
 *   unsigned int	*width_return;
 *   unsigned int	*height_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XParseGeometry	1
char    *TestName = "XParseGeometry";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XParseGeometry function
 */
static char	*parsestring;
static int	*x_return;
static int	*y_return;
static unsigned int	*width_return;
static unsigned int	*height_return;


static int 	ValueReturn;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	parsestring = 0;
	x_return = 0;
	y_return = 0;
	width_return = 0;
	height_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#define	DEFV	123
static struct	list {
	char	*pstr;	/* Parse string */
	int 	flags;	/* returned flags */
	int 	x;
	int 	y;
	unsigned int    width;
	unsigned int    height;
} list[] = {
	{"=10x20", WidthValue|HeightValue, DEFV, DEFV, 10, 20},
	{"=+10+20", XValue|YValue, 10, 20, DEFV, DEFV},
	{"=1x2-10-20", WidthValue|HeightValue|XValue|YValue|XNegative|YNegative, -10, -20, 1, 2},
	{"=1x2-0-0", WidthValue|HeightValue|XValue|YValue|XNegative|YNegative, 0, 0, 1, 2},
	{"=10x20+2-3", WidthValue|HeightValue|XValue|YValue|YNegative, 2, -3, 10, 20}
};
struct	list	*lp;
int		i;
int		xr;
int		yr;
unsigned int		wr;
unsigned int		hr;
int		result;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XParseGeometry-1.(A)");
	report_assertion("When the parsestring argument is a string of the form");
	report_assertion("[=][<width>x<height>][{+-}<xoffset>{+-}<yoffset>] then a");
	report_assertion("call to XParseGeometry returns a bitwise OR of WidthValue|");
	report_assertion("HeightValue, XValue|YValue, XNegative or YNegative");
	report_assertion("depending on whether the height and width are specified,");
	report_assertion("whether the offsets are specified and on the sign of the");
	report_assertion("specified offsets respectively.");

	report_strategy("For geometry strings covering each case of interest");
	report_strategy("  Parse string with XParseGeometry.");
	report_strategy("  Verify that correct flags are set.");
	report_strategy("  For each value");
	report_strategy("	If corresponding flag is set");
	report_strategy("	  Verify that value is set correctly.");
	report_strategy("	else");
	report_strategy("	  Verify that value is unchanged.");

	tpstartup();
	setargs();
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;

	/*
	 * Essentially we run through the list twice, the first time
	 * without the '=' the second time with.
	 */
	for(i=0; i < 2*NELEM(list); i++) {

		lp = &list[i%NELEM(list)];

		/* Set all values to some default */
		xr = yr = wr = hr = DEFV;

		/* Set parse string, and skip the '=' if this is first time through */
		parsestring = lp->pstr;
		if (i < NELEM(list))
			parsestring++;
		trace("parse string of \"%s\"", parsestring);
		startcall(Dsp);
		if (isdeleted())
			return;
		result = XParseGeometry(parsestring, x_return, y_return, width_return, height_return);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if(result != lp->flags) {
			report("%s() returned 0x%x instead of 0x%x for parsestring \"%s\".", TestName, result, lp->flags, parsestring);
			FAIL;
		} else
			CHECK;

		if (xr == lp->x)
			CHECK;
		else if (lp->x == DEFV) {
			report("x_return was unexpectedly altered to %d", xr);
			FAIL;
		} else {
			report("Returned x value was %d, expecting %d", xr, lp->x);
			FAIL;
		}
		if (yr == lp->y)
			CHECK;
		else if (lp->y == DEFV) {
			report("y_return was unexpectedly altered to %d", yr);
			FAIL;
		} else {
			report("Returned y value was %d, expecting %d", yr, lp->y);
			FAIL;
		}
		if (wr == lp->width)
			CHECK;
		else if (lp->width == DEFV) {
			report("width_return was unexpectedly altered to %u", wr);
			FAIL;
		} else {
			report("Returned width value was %u, expecting %u", wr, lp->width);
			FAIL;
		}
		if (hr == lp->height)
			CHECK;
		else if (lp->x == DEFV) {
			report("height_return was unexpectedly altered to %u", hr);
			FAIL;
		} else {
			report("Returned height value was %u, expecting %u", hr, lp->height);
			FAIL;
		}
	}

	CHECKPASS(5*2*NELEM(list));

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int		xr = -1;
int		yr = -1;
int		wr = -13;
int		hr = -666;
int		rres;
int		result;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XParseGeometry-2.(A)");
	report_assertion("When the parsestring argument contains just xoffset and");
	report_assertion("yoffset specifications, then a call to XParseGeometry");
	report_assertion("returns these values in the x_return and y_return arguments");
	report_assertion("respectively and the width_return and height_return");
	report_assertion("arguments are not altered.");

	report_strategy("Parse the string  \"+32768-32768\" using XParseGeometry.");
	report_strategy("Verify that the call returns XValue | YValue | YNegative.");
	report_strategy("Verify that the x_return argument is set to 32768.");
	report_strategy("Verify that the y_return argument is set to -32768.");
	report_strategy("Verify that the width_return argument is unaltered.");
	report_strategy("Verify that the height_return argument is unaltered.");

	tpstartup();
	setargs();
	parsestring = "+32768-32768";
	x_return = &xr;
	y_return = &yr;
	width_return = (unsigned *)&wr;
	height_return = (unsigned *)&hr;

	startcall(Dsp);
	if (isdeleted())
		return;
	result = XParseGeometry(parsestring, x_return, y_return, width_return, height_return);	
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(result !=  (rres = XValue | YValue | YNegative)) {
		report("%s() returned %d instead of %d for parsestring \"%s\".", TestName, result, rres, parsestring);
		FAIL;
	} else
		CHECK;

	if(xr != 32768) {
		report("%s() returned %d in x_return instead of %d.", TestName, xr, 32768);
		FAIL;
	} else
		CHECK;

	if(yr != -32768) {
		report("%s() returned %d in y_return instead of %d.", TestName, yr, -32768);
		FAIL;
	} else
		CHECK;

	if(wr != -13) {
		report("%s() changed the width_return argument.", TestName);
		FAIL;
	} else
		CHECK;

	if(hr != -666) {
		report("%s() changed the height_return argument.", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int		xr = -77;
int		yr = -33;
unsigned int		wr = 16385;
unsigned int		hr = 33768;
int		rres;
int		result;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XParseGeometry-3.(A)");
	report_assertion("When the parsestring argument contains just width and");
	report_assertion("height specifications, then a call to XParseGeometry returns");
	report_assertion("these values in the width_return and height_return arguments");
	report_assertion("respectively and the x_return and y_return arguments are not");
	report_assertion("altered.");

	report_strategy("Parse the string \"16385x33768\" using XParseGeometry.");
	report_strategy("Verify that the call returns WidthValue | HeightValue.");
	report_strategy("Verify that the width_return argument is set to 16385.");
	report_strategy("Verify that the height_return argument is set to 33768.");
	report_strategy("Verify that the x_return argument is unaltered.");
	report_strategy("Verify that the y_return argument is unaltered.");

	tpstartup();
	setargs();
	parsestring = "16385x33768";
	x_return = &xr;
	y_return = &yr;
	width_return = &wr;
	height_return = &hr;

	startcall(Dsp);
	if (isdeleted())
		return;
	result = XParseGeometry(parsestring, x_return, y_return, width_return, height_return);	
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(result !=  (rres = WidthValue | HeightValue)) {
		report("%s() returned %d instead of %d for parsestring \"%s\".", TestName, result, rres, parsestring);
		FAIL;
	} else
		CHECK;

	if(wr != 16385) {
		report("%s() returned %u in width_return instead of %d.", TestName, wr, 16385);
		FAIL;
	} else
		CHECK;

	if(hr != 33768) {
		report("%s() returned %u in height_return instead of %d.", TestName, hr, 33768);
		FAIL;
	} else
		CHECK;

	if(xr != -77) {
		report("%s() changed the x_return argument.", TestName);
		FAIL;
	} else
		CHECK;

	if(yr != -33) {
		report("%s() changed the y_return argument.", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
