/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return)
 *   Display *display;
 *   Drawable d;
 *   char *filename;
 *   unsigned int *width_return;
 *   unsigned int *height_return;
 *   Pixmap *bitmap_return;
 *   int *x_hot_return;
 *   int *y_hot_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XReadBitmapFile	1
char    *TestName = "XReadBitmapFile";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d


/*
 * Arguments to the XReadBitmapFile function
 */
static Display *display;
static Drawable d;
static char *filename;
static unsigned int *width_return;
static unsigned int *height_return;
static Pixmap *bitmap_return;
static int *x_hot_return;
static int *y_hot_return;


static int 	ValueReturn;

#include <stdio.h>

/* Function return variables. */
static unsigned int width;
static unsigned int height;
static Pixmap bitmap;
static int x_hot;
static int y_hot;

/* Temporary bitmap filename. */
static char *xrbf_name = "xrbf_temp";
static char *xrbf_bad_name = "xrbf_nofile";

/* Valid bitmap file without hotspot definition. */
static char *xrbf_one[] = {
	"#define test_width 16",
	"#define test_height 8",
	"static char test_bits[] = {",
	"0x80, 0x00, 0x3f, 0xfe, 0x04, 0x07, 0x88, 0x41,",
	"0xfc, 0x09, 0x00, 0x80, 0x40, 0x20, 0x08, 0x04};",
} ;
static int xrbf_n_one = NELEM(xrbf_one);

/* Valid bitmap file with hotspot definition. */
static char *xrbf_two[] = {
	"#define test_width 16",
	"#define test_height 8",
	"#define test_x_hot 5",
	"#define test_y_hot 6",
	"static char test_bits[] = {",
	"0x80, 0x00, 0x3f, 0xfe, 0x04, 0x07, 0x88, 0x41,",
	"0xfc, 0x09, 0x00, 0x80, 0x40, 0x20, 0x08, 0x04};",
} ;
static int xrbf_n_two = NELEM(xrbf_two);

/* Invalid bitmap file. */
static char *xrbf_three[] = {
	"#define not bit map data",
	"static char data_bits[]={",
	"};",
};
static int xrbf_n_three = NELEM(xrbf_three);

static char *xrbf_verify_array[8]={
	"0000000100000000",
	"1111110001111111",
	"0010000011100000",
	"0001000110000010",
	"0011111110010000",
	"0000000000000001",
	"0000001000000100",
	"0001000000100000",
};


static int
xrbf_create(file, data, elements)
char *file;
char **data;
int elements;
{
	FILE *fp;
	int a;

	fp = fopen(file, "w");
	if (fp == (FILE *)NULL) {
		delete("Could not create temporary bitmap file '%s'", file);
		return -1;
	}

	a = 0;
	while( a<elements ) {
		fprintf(fp, "%s\n", data[a++]);
	}

	fclose(fp);
	return 0;
}

static void
xrbf_b_start() {
	tpstartup();
	xrbf_create(xrbf_name, xrbf_one, xrbf_n_one);
}


static void
xrbf_b_end()  {
	unlink(xrbf_name);
	tpcleanup();
}

static int
xrbf_check(pm, array, w, h)
Pixmap pm;
char **array;
int w;
int h;
{
	int lh, lw, bad;
	unsigned long exp;

	bad = 0;
	for(lh=0; lh<h; lh++) {
		for(lw=0; lw<w; lw++) {
			int pix;
			exp = (array[lh][lw]=='0'?W_BG:W_FG);
			pix = checkpixel(display, pm, lw, lh, exp);
			if ( !pix ) {
				trace("Bad Pixel at %d,%d", lw, lh);
				bad++;
			}
		}
	}

	return bad;
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = (Drawable)defwin(display);
	filename = xrbf_name;
	width_return = &width;
	height_return = &height;
	bitmap_return = &bitmap;
	x_hot_return = &x_hot;
	y_hot_return = &y_hot;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XReadBitmapFile-1.(A)");
	report_assertion("When the file filename is readable and in the X11 bitmap");
	report_assertion("format, then a call to XReadBitmapFile returns BitmapSuccess.");

	report_strategy("Create a valid, readable, bitmap file.");
	report_strategy("Call XReadBitmapFile to read the bitmap file.");
	report_strategy("Verify that BitmapSuccess was returned.");

	tpstartup();
	setargs();
/* Create a valid, readable, bitmap file. */
	if (xrbf_create(filename, xrbf_two, xrbf_n_two)) {
		return;
	} else
		CHECK;

/* Call xname to read the bitmap file. */
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (ValueReturn != BitmapSuccess) {
		report("Returned value was %d, expecting BitmapSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	unlink(filename);
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window rw_ret, rw2_ret;
int i_tmp;
unsigned int h_ret, w_ret, d_ret, ui_tmp;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XReadBitmapFile-2.(A)");
	report_assertion("When the file filename is readable and in the X11 bitmap");
	report_assertion("format, then a call to XReadBitmapFile returns the bitmap's");
	report_assertion("height and width as read from the file in width_return and");
	report_assertion("height_return, and a pixmap containing the bitmap with the");
	report_assertion("bitmap's height and width, on the same screen as the");
	report_assertion("drawable, in bitmap_return.");

	report_strategy("Create a valid, readable, bitmap file.");
	report_strategy("Call XReadBitmapFile to read the bitmap file.");
	report_strategy("Verify that the width was returned as expected.");
	report_strategy("Verify that the height was returned as expected.");
	report_strategy("Call XGetGeometry to obtain the bitmap width, height and depth.");
	report_strategy("Verify that the bitmap was of the correct height, width and depth.");
	report_strategy("Verify that the bitmap contents were correct.");
	report_strategy("Verify that the bitmap was created on the correct screen.");

	tpstartup();
	setargs();
/* Create a valid, readable, bitmap file. */
	if (xrbf_create(filename, xrbf_one, xrbf_n_one)) {
		return;
	} else
		CHECK;

/* Call xname to read the bitmap file. */
	width = 0;
	height = 0;
	bitmap = (Pixmap)NULL;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (ValueReturn != BitmapSuccess) {
		report("Returned value was %d, expecting BitmapSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the width was returned as expected. */
	if (width != 16) {
		FAIL;
		report("%s did not return the expected width",
			TestName);
		report("Expected width: 16");
		report("Returned width: %d", width);
	} else
		CHECK;

/* Verify that the height was returned as expected. */
	if (height != 8) {
		FAIL;
		report("%s did not return the expected height",
			TestName);
		report("Expected height: 8");
		report("Returned height: %d", height);
	} else
		CHECK;

/* Call XGetGeometry to obtain the bitmap width, height and depth. */
	(void)XGetGeometry(display, bitmap, &rw_ret, &i_tmp, &i_tmp,
		&w_ret, &h_ret, &ui_tmp, &d_ret);

/* Verify that the bitmap was of the correct height, width and depth. */
	if (w_ret != 16 || h_ret != 8 || d_ret != 1) {
		FAIL;
		report("%s created a pixmap of unexpected dimensions.",
			TestName);
		report("Expected width :16; Returned width :%u", w_ret);
		report("Expected height: 8; Returned height:%u", h_ret);
		report("Expected depth : 1; Returned depth :%u", d_ret);
	} else
		CHECK;

/* Verify that the bitmap contents were correct. */
	if (xrbf_check(bitmap, xrbf_verify_array, 16, 8)) {
		FAIL;
		report("%s did not generate the expected pixmap.",
			TestName);
	} else
		CHECK;

/* Verify that the bitmap was created on the correct screen. */
	(void)XGetGeometry(display, d, &rw2_ret, &i_tmp, &i_tmp,
		&ui_tmp, &ui_tmp, &ui_tmp, &ui_tmp);
	if(rw2_ret != rw_ret) {
		FAIL;
		report("%s did not generate the pixmap on the expected screen.",
			TestName);
		report("Root window for drawable and bitmap differ.");
	} else
		CHECK;
		
	unlink(filename);

	CHECKPASS(6);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XReadBitmapFile-3.(A)");
	report_assertion("When the file filename is readable, and in the X11 bitmap");
	report_assertion("format, and contains name_x_hot and name_y_hot, then a call");
	report_assertion("to XReadBitmapFile returns the value of name_x_hot to");
	report_assertion("x_hot_return, and the value of name_y_hot to y_hot_return.");

	report_strategy("Create a valid, readable, bitmap file containing a hotspot.");
	report_strategy("Call XReadBitmapFile to read the bitmap file.");
	report_strategy("Verify that the x_hot_return was returned as expected.");
	report_strategy("Verify that the y_hot_return was returned as expected.");

	tpstartup();
	setargs();
/* Create a valid, readable, bitmap file containing a hotspot. */
	if (xrbf_create(filename, xrbf_two, xrbf_n_two)) {
		return;
	} else
		CHECK;

/* Call xname to read the bitmap file. */
	x_hot = 0;
	y_hot = 0;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (ValueReturn != BitmapSuccess) {
		report("Returned value was %d, expecting BitmapSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the x_hot_return was returned as expected. */
	if (x_hot != 5) {
		FAIL;
		report("%s did not return the expected x_hot_return",
			TestName);
		report("Expected x_hot_return: 5");
		report("Returned x_hot_return: %d", x_hot);
	} else
		CHECK;

/* Verify that the y_hot_return was returned as expected. */
	if (y_hot != 6) {
		FAIL;
		report("%s did not return the expected y_hot_return",
			TestName);
		report("Expected y_hot_return: 6");
		report("Returned y_hot_return: %d", y_hot);
	} else
		CHECK;

	unlink(filename);

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XReadBitmapFile-4.(A)");
	report_assertion("When the file filename is readable, and in the X11 bitmap");
	report_assertion("format, and does not contain name_x_hot and name_y_hot,");
	report_assertion("then a call to XReadBitmapFile returns -1 to x_hot_return");
	report_assertion("and y_hot_return.");

	report_strategy("Create a valid, readable, bitmap file containing no hotspot.");
	report_strategy("Call XReadBitmapFile to read the bitmap file.");
	report_strategy("Verify that the x_hot_return was returned as expected.");
	report_strategy("Verify that the y_hot_return was returned as expected.");

	tpstartup();
	setargs();
/* Create a valid, readable, bitmap file containing no hotspot. */
	if (xrbf_create(filename, xrbf_one, xrbf_n_one)) {
		return;
	} else
		CHECK;

/* Call xname to read the bitmap file. */
	x_hot = 0;
	y_hot = 0;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (ValueReturn != BitmapSuccess) {
		report("Returned value was %d, expecting BitmapSuccess", ValueReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the x_hot_return was returned as expected. */
	if (x_hot != -1) {
		FAIL;
		report("%s did not return the expected x_hot_return",
			TestName);
		report("Expected x_hot_return: -1");
		report("Returned x_hot_return: %d", x_hot);
	} else
		CHECK;

/* Verify that the y_hot_return was returned as expected. */
	if (y_hot != -1) {
		FAIL;
		report("%s did not return the expected y_hot_return",
			TestName);
		report("Expected y_hot_return: -1");
		report("Returned y_hot_return: %d", y_hot);
	} else
		CHECK;

	unlink(filename);

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XReadBitmapFile-5.(A)");
	report_assertion("When the file filename cannot be opened, then a call to");
	report_assertion("XReadBitmapFile returns BitmapOpenFailed.");

	report_strategy("Call XReadBitmapFile with a non-existant bitmap filename.");
	report_strategy("Verify that BitmapOpenFailed was returned.");

	tpstartup();
	setargs();
/* Call xname with a non-existant bitmap filename. */
	filename = xrbf_bad_name;
	startcall(display);
	if (isdeleted())
		return;
	ret = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that BitmapOpenFailed was returned. */
	if (ret != BitmapOpenFailed) {
		FAIL;
		report("%s did not return correct value with a nonexistant",
			TestName);
		report("bitmap file.");
		report("Expected: %d (BitmapOpenFailed)");
		report("Returned: %d", ret);
	} else
		CHECK;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XReadBitmapFile-6.(A)");
	report_assertion("When the file filename is readable and does not contain");
	report_assertion("valid bitmap data, then a call to XReadBitmapFile returns");
	report_assertion("BitmapFileInvalid.");

	report_strategy("Create an invalid, bitmap file.");
	report_strategy("Call XReadBitmapFile to read the bitmap file.");
	report_strategy("Verify that BitmapFileInvalid was returned.");

	tpstartup();
	setargs();
/* Create an invalid, bitmap file. */
	if (xrbf_create(filename, xrbf_three, xrbf_n_three)) {
		return;
	} else
		CHECK;

/* Call xname to read the bitmap file. */
	startcall(display);
	if (isdeleted())
		return;
	ret = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that BitmapFileInvalid was returned. */
	if (ret != BitmapFileInvalid) {
		FAIL;
		report("%s did not return correct value with an invalid",
			TestName);
		report("bitmap file.");
		report("Expected: %d (BitmapFileInvalid)");
		report("Returned: %d", ret);
	} else
		CHECK;

	unlink(filename);

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28793 */
static void t007(){

int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XReadBitmapFile-7.(B)");
	report_assertion("When insufficient memory is allocated, then a call to");
	report_assertion("XReadBitmapFile returns BitmapNoMemory.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28793 */

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t008(){

int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XReadBitmapFile-8.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	xrbf_b_start();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	xrbf_b_end();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XReadBitmapFile-9.(A)");
	report_assertion("When a drawable argument does not name a valid drawable,");
	report_assertion("then one or more BadDrawable errors, one or more BadGC");
	report_assertion("errors or both types of error occur.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable and BadGC error occurs.");

	xrbf_b_start();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XReadBitmapFile(display, d, filename, width_return, height_return, bitmap_return, x_hot_return, y_hot_return);
	endcall(display);
	if (ValueReturn != BitmapSuccess) {
		report("Returned value was %d, expecting BitmapSuccess", ValueReturn);
		FAIL;
	}

	if (geterr() == BadDrawable || geterr() == BadGC)
		PASS;
	else
		FAIL;
	xrbf_b_end();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
