/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XGetGeometry(display, d, root_return, x_return, y_return, width_return, height_return, border_width_return, depth_return)
 *   Display *display;
 *   Drawable d;
 *   Window  *root_return;
 *   int *x_return;
 *   int *y_return;
 *   unsigned int *width_return;
 *   unsigned int *height_return;
 *   unsigned int *border_width_return;
 *   unsigned int *depth_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetGeometry	1
char    *TestName = "XGetGeometry";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_DRAWABLE d


/*
 * Arguments to the XGetGeometry function
 */
static Display *display;
static Drawable d;
static Window  *root_return;
static int *x_return;
static int *y_return;
static unsigned int *width_return;
static unsigned int *height_return;
static unsigned int *border_width_return;
static unsigned int *depth_return;


static int 	StatusReturn;

#define XGG_BorderWidth 5
#define XGG_X 25
#define XGG_Y 35
#define XGG_Width 20
#define XGG_Height 15

Window root;
int x;
int y;
unsigned int width;
unsigned int height;
unsigned int border_width;
unsigned int depth;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	d = 0;
	root_return = &root;
	x_return = &x;
	y_return = &y;
	width_return = &width;
	height_return = &height;
	border_width_return = &border_width;
	depth_return = &depth;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	d = ErrdefDrawable;
}

static void t001(){

XVisualInfo *vp;
struct area ap;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetGeometry-1.(A)");
	report_assertion("When the drawable is an InputOutput window, then a call to");
	report_assertion("XGetGeometry returns the root window in root_return, the x");
	report_assertion("and y coordinates of the upper-left outer corner relative to");
	report_assertion("the parent window origin in x_return and y_return, the");
	report_assertion("inside width and height in width_return and height_return,");
	report_assertion("the border width in border_width_return, and the depth of");
	report_assertion("the window in depth_return.");

	report_strategy("For each visual and depth:");
	report_strategy("	Create a parent window");
	report_strategy("	Create a test window");
	report_strategy("	Call XGetGeometry to obtain the test window geometry");
	report_strategy("	Verify that the values returned were as expected");

	tpstartup();
	setargs();
/* For each visual and depth: */
	for(resetvinf(VI_WIN);  nextvinf(&vp); ) {
		Window parent, w;

/* 	Create a parent window */
		ap.x = 7;
		ap.y = 11;
		ap.width = 9;
		ap.height = 13;

		parent = makewin(display, vp);

/* 	Create a test window */
		w = mkwinchild(display, vp, &ap, 0, parent, XGG_BorderWidth);

/* 	Call xname to obtain the test window geometry */
		root = (Window)0;
		x = -1;
		y = -1;
		width = 255;
		height = 255;
		border_width = 255;
		depth = 255;

		d = (Drawable)w;
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XGetGeometry(display, d, root_return, x_return, y_return, width_return, height_return, border_width_return, depth_return);
		endcall(display);
		if (StatusReturn == 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

/* 	Verify that the values returned were as expected */
		if (root != DefaultRootWindow(display)) {
			FAIL;
			report("%s did not return the expected root window",
				TestName);
			trace("Expected root=%0x", DefaultRootWindow(display));
			trace("Returned root=%0x", root);
		} else
			CHECK;

		if (x != ap.x) {
			FAIL;
			report("%s did not return the expected x coordinate",
				TestName);
			trace("Expected x=%d", ap.x);
			trace("Returned x=%d", x);
		} else
			CHECK;
		
		if (y != ap.y) {
			FAIL;
			report("%s did not return the expected y coordinate",
				TestName);
			trace("Expected y=%d", ap.y);
			trace("Returned y=%d", y);
		} else
			CHECK;

		if (width != ap.width) {
			FAIL;
			report("%s did not return the expected width",
				TestName);
			trace("Expected width=%u", ap.width);
			trace("Returned width=%u", width);
		} else
			CHECK;

		if (height != ap.height) {
			FAIL;
			report("%s did not return the expected height",
				TestName);
			trace("Expected height=%u", ap.height);
			trace("Returned height=%u", height);
		} else
			CHECK;

		if (border_width != XGG_BorderWidth) {
			FAIL;
			report("%s did not return the expected border_width",
				TestName);
			trace("Expected border_width=%u", XGG_BorderWidth);
			trace("Returned border_width=%u", border_width);
		} else
			CHECK;

		if (depth != vp->depth) {
			FAIL;
			report("%s did not return the expected depth",
				TestName);
			trace("Expected depth=%u", vp->depth);
			trace("Returned depth=%u", depth);
		} else
			CHECK;
	}

	CHECKPASS(7*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window parent, w;
XSetWindowAttributes atts;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetGeometry-2.(A)");
	report_assertion("When the drawable is an InputOnly window, then a call to");
	report_assertion("XGetGeometry returns the root window in root_return, the x");
	report_assertion("and y coordinates of the upper-left outer corner relative to");
	report_assertion("the parent window origin in x_return and y_return, the");
	report_assertion("inside width and height of the window in width_return and");
	report_assertion("height_return, and sets border_width_return and");
	report_assertion("depth_return to zero.");

	report_strategy("Create a parent window");
	report_strategy("Create an InputOnly test window");
	report_strategy("Call XGetGeometry to obtain the test window geometry");
	report_strategy("Verify that the returned values were as expected");

	tpstartup();
	setargs();
/* Create a parent window */
	parent = defwin(display);

/* Create an InputOnly test window */
	atts.override_redirect = config.debug_override_redirect;
	w = XCreateWindow(display, parent, XGG_X, XGG_Y, XGG_Width, XGG_Height,
			0, 0, InputOnly, CopyFromParent,
			CWOverrideRedirect, &atts);
	regid(display, (union regtypes *)&w, REG_WINDOW);

/* Call xname to obtain the test window geometry */
	root = (Window)0;
	x = -1;
	y = -1;
	width = 255;
	height = 255;
	border_width = 255;
	depth = 255;

	d = (Drawable)w;
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetGeometry(display, d, root_return, x_return, y_return, width_return, height_return, border_width_return, depth_return);
	endcall(display);
	if (StatusReturn == 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the returned values were as expected */
	if (root != DefaultRootWindow(display)) {
		FAIL;
		report("%s did not return the expected root window",
			TestName);
		trace("Expected root=%0x", DefaultRootWindow(display));
		trace("Returned root=%0x", root);
	} else
		CHECK;

	if (x != XGG_X) {
		FAIL;
		report("%s did not return the expected x coordinate",
			TestName);
		trace("Expected x=%d", XGG_X);
		trace("Returned x=%d", x);
	} else
		CHECK;
	
	if (y != XGG_Y) {
		FAIL;
		report("%s did not return the expected y coordinate",
			TestName);
		trace("Expected y=%d", XGG_Y);
		trace("Returned y=%d", y);
	} else
		CHECK;

	if (width != XGG_Width) {
		FAIL;
		report("%s did not return the expected width",
			TestName);
		trace("Expected width=%u", XGG_Width);
		trace("Returned width=%u", width);
	} else
		CHECK;

	if (height != XGG_Height) {
		FAIL;
		report("%s did not return the expected height",
			TestName);
		trace("Expected height=%u", XGG_Height);
		trace("Returned height=%u", height);
	} else
		CHECK;

	if (border_width != 0) {
		FAIL;
		report("%s did not return the expected border_width",
			TestName);
		trace("Expected border_width=%u", 0);
		trace("Returned border_width=%u", border_width);
	} else
		CHECK;

	if (depth != 0) {
		FAIL;
		report("%s did not return the expected depth",
			TestName);
		trace("Expected depth=%u", 0);
		trace("Returned depth=%u", depth);
	} else
		CHECK;

	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetGeometry-3.(A)");
	report_assertion("When the drawable is a pixmap, then a call to XGetGeometry");
	report_assertion("returns the root window in root_return, the inside width");
	report_assertion("and height in width_return and height_return, the depth of");
	report_assertion("the pixmap in depth_return, and sets x_return, y_return,");
	report_assertion("and border_width_return to zero.");

	report_strategy("For each depth:");
	report_strategy("	Create a parent window");
	report_strategy("	Create a test pixmap");
	report_strategy("	Call XGetGeometry to obtain the test pixmap geometry");
	report_strategy("	Verify that the values returned were as expected");

	tpstartup();
	setargs();
/* For each depth: */
	for(resetvinf(VI_PIX);  nextvinf(&vp); ) {
		Window parent;
		Pixmap pm;

/* 	Create a parent window */
		parent = makewin(display, vp);

/* 	Create a test pixmap */
		pm = XCreatePixmap(display, parent,
			XGG_Width, XGG_Height, vp->depth);
		regid(display, (union regtypes *)&pm, REG_PIXMAP);

/* 	Call xname to obtain the test pixmap geometry */
		root = (Window)0;
		x = -1;
		y = -1;
		width = 255;
		height = 255;
		border_width = 255;
		depth = 255;

		d = (Drawable)pm;
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XGetGeometry(display, d, root_return, x_return, y_return, width_return, height_return, border_width_return, depth_return);
		endcall(display);
		if (StatusReturn == 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

/* 	Verify that the values returned were as expected */
		if (root != DefaultRootWindow(display)) {
			FAIL;
			report("%s did not return the expected root window",
				TestName);
			trace("Expected root=%0x", DefaultRootWindow(display));
			trace("Returned root=%0x", root);
		} else
			CHECK;

		if (x != 0) {
			FAIL;
			report("%s did not return the expected x coordinate",
				TestName);
			trace("Expected x=%d", 0);
			trace("Returned x=%d", x);
		} else
			CHECK;
		
		if (y != 0) {
			FAIL;
			report("%s did not return the expected y coordinate",
				TestName);
			trace("Expected y=%d", 0);
			trace("Returned y=%d", y);
		} else
			CHECK;

		if (width != XGG_Width) {
			FAIL;
			report("%s did not return the expected width",
				TestName);
			trace("Expected width=%u", XGG_Width);
			trace("Returned width=%u", width);
		} else
			CHECK;

		if (height != XGG_Height) {
			FAIL;
			report("%s did not return the expected height",
				TestName);
			trace("Expected height=%u", XGG_Height);
			trace("Returned height=%u", height);
		} else
			CHECK;

		if (border_width != 0) {
			FAIL;
			report("%s did not return the expected border_width",
				TestName);
			trace("Expected border_width=%u", 0);
			trace("Returned border_width=%u", border_width);
		} else
			CHECK;

		if (depth != vp->depth) {
			FAIL;
			report("%s did not return the expected depth",
				TestName);
			trace("Expected depth=%u", vp->depth);
			trace("Returned depth=%u", depth);
		} else
			CHECK;
	}

	CHECKPASS(7*nvinf());
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

/* Including from file error/EDra.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetGeometry-4.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XGetGeometry(display, d, root_return, x_return, y_return, width_return, height_return, border_width_return, depth_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadDrawable)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EDra.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
