/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Cursor
 *   XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y)
 *   Display *display;
 *   Pixmap source;
 *   Pixmap mask;
 *   XColor *foreground_color;
 *   XColor *background_color;
 *   unsigned int x;
 *   unsigned int y;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCreatePixmapCursor	1
char    *TestName = "XCreatePixmapCursor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_PIXMAP source
#define A_DRAWABLE source
#define A_PIXMAP2 mask
#define A_DRAWABLE2 mask


/*
 * Arguments to the XCreatePixmapCursor function
 */
static Display *display;
static Pixmap source;
static Pixmap mask;
static XColor *foreground_color;
static XColor *background_color;
static unsigned int x;
static unsigned int y;


static XVisualInfo depth1;

/*
 * mkcolor() -	return a pointer to a color structure.
 *		flag indicates whether or not color is foreground
 */
static XColor *
mkcolor(flag)
{
	static	XColor	fore;
	static	XColor	back;
	static	int	first = 1;

	if (first)
	{
		first = 0;

		fore.pixel = BlackPixel(display, DefaultScreen(display));
		XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &fore);
		back.pixel = WhitePixel(display, DefaultScreen(display));
		XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &back);
	}
	return(flag ? &fore : &back);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	source = 0;
	mask = 0;
	foreground_color = mkcolor(1);
	background_color = mkcolor(0);
	x = 0;
	y = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	source = ErrdefPixmap;
	mask = ErrdefPixmap;
}

static void t001(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCreatePixmapCursor-1.(B)");
	report_assertion("A call to XCreatePixmapCursor creates a Cursor from the");
	report_assertion("source and mask pixmaps with colours defined by");
	report_assertion("foreground_color and background_color and hotspot position");
	report_assertion("given by x and y and returns the cursor ID.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with foreground colour W_FG and");
	report_strategy("background colour W_BG and hotspot at (0,0).");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);

/* Create mask pixmap. */
	mask = makepixm(display, &depth1);

/* Call XCreatePixmapCursor with foreground colour W_FG and */
/* background colour W_BG and hotspot at (0,0). */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCreatePixmapCursor-2.(B)");
	report_assertion("When mask is None, then all pixels of the source are");
	report_assertion("displayed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Call XCreatePixmapCursor with mask None.");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);

	mask = None;
/* Call XCreatePixmapCursor with mask None. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCreatePixmapCursor-3.(B)");
	report_assertion("When mask is other than None and a given bit in the mask");
	report_assertion("bitmap is 1, then the corresponding pixel of source is");
	report_assertion("displayed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with mask other than none and");
	report_strategy("mask with at least one bit set.");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);
/* Create mask pixmap. */
	mask = makepixm(display, &depth1);

/* Call XCreatePixmapCursor with mask other than none and */
/* mask with at least one bit set. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCreatePixmapCursor-4.(B)");
	report_assertion("When mask is other than None and a given bit in the mask");
	report_assertion("bitmap is 0, then the corresponding pixel of source is not");
	report_assertion("displayed.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with mask other than none and");
	report_strategy("mask with at least one bit not set.");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);
/* Create mask pixmap. */
	mask = makepixm(display, &depth1);
	dset(display, (Drawable) mask, (unsigned long) 0);

/* Call XCreatePixmapCursor with mask other than none and */
/* mask with at least one bit not set. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCreatePixmapCursor-5.(B)");
	report_assertion("When a bit in the source bitmap is 1, then foreground_color");
	report_assertion("is used.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with source bitmap containing");
	report_strategy("at least one bit set to 1.");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);
/* Create mask pixmap. */
	mask = makepixm(display, &depth1);

/* Call XCreatePixmapCursor with source bitmap containing */
/* at least one bit set to 1. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XCreatePixmapCursor-6.(B)");
	report_assertion("When a bit in the source bitmap is 0, then background_color");
	report_assertion("is used.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with source bitmap containing");
	report_strategy("at least one bit set to 0.");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);
	dset(display, (Drawable) source, 0);
/* Create mask pixmap. */
	mask = makepixm(display, &depth1);

/* Call XCreatePixmapCursor with source bitmap containing */
/* at least one bit set to 0. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Cursor qstat;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XCreatePixmapCursor-7.(B)");
	report_assertion("When a Cursor is created by a call to XCreatePixmapCursor,");
	report_assertion("and the source and/or mask argument is freed by a subsequent");
	report_assertion("call to XFreePixmap, then the cursor is unaffected.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with mask other than none and");
	report_strategy("mask with at least one bit set.");
	report_strategy("Verify that XCreatePixmapCursor returns non-zero.");
	report_strategy("Call XFreePixmap with source pixmap.");
	report_strategy("Call XFreePixmap with mask pixmap.");

	tpstartup();
	setargs();
/* Create source pixmap. */
	source = XCreatePixmap(display, DRW(display), 2, 2, 1);
/* Create mask pixmap. */
	mask = XCreatePixmap(display, DRW(display), 2, 2, 1);

/* Call XCreatePixmapCursor with mask other than none and */
/* mask with at least one bit set. */
	startcall(display);
	if (isdeleted())
		return;
	qstat = XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that XCreatePixmapCursor returns non-zero. */
	if (qstat == (Cursor) 0) {
		report("Returned incorrect value %ld", (long) qstat);
		FAIL;
	} else
		CHECK;
	
/* Call XFreePixmap with source pixmap. */
	XFreePixmap(display, source);

/* Call XFreePixmap with mask pixmap. */
	XFreePixmap(display, mask);
	
	CHECKUNTESTED(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

XVisualInfo *vp;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XCreatePixmapCursor-8.(C)");
	report_assertion("If multiple window depths are supported: When source does");
	report_assertion("not have depth one, then a BadMatch error occurs.");

	report_strategy("If only one depth supported report UNSUPPORTED.");
	report_strategy("Create source pixmap of depth not equal to one.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with source pixmap.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* If only one depth supported report UNSUPPORTED. */
	for (resetvinf(VI_PIX); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			depth1.depth = vp->depth;
			break;
		}
	}
	if (depth1.depth == 1) {
                unsupported("Only one depth of window is supported");
		return;
	}
/* Create source pixmap of depth not equal to one. */
	source = makepixm(display, &depth1);
/* Create mask pixmap. */
	depth1.depth = 1;
	mask = makepixm(display, &depth1);

/* Call XCreatePixmapCursor with source pixmap. */
	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that BadMatch error occurred. */
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

XVisualInfo *vp;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XCreatePixmapCursor-9.(A)");
	report_assertion("When mask is not None and mask does not have depth one,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("If only one depth supported report UNSUPPORTED.");
	report_strategy("Create mask pixmap of depth not equal to one.");
	report_strategy("Create source pixmap.");
	report_strategy("Call XCreatePixmapCursor with mask pixmap.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* If only one depth supported report UNSUPPORTED. */
	for (resetvinf(VI_PIX); nextvinf(&vp); ) {
		if (vp->depth != 1) {
			depth1.depth = vp->depth;
			break;
		}
	}
	if (depth1.depth == 1) {
		report("Only one depth supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}
/* Create mask pixmap of depth not equal to one. */
	mask = makepixm(display, &depth1);
/* Create source pixmap. */
	depth1.depth = 1;
	source = makepixm(display, &depth1);

/* Call XCreatePixmapCursor with mask pixmap. */
	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that BadMatch error occurred. */
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XCreatePixmapCursor-10.(A)");
	report_assertion("When mask is not None and both source and mask are not the");
	report_assertion("same size, then a BadMatch error occurs.");

	report_strategy("Create source pixmap of size 1x1.");
	report_strategy("Create mask pixmap of size 2x2.");
	report_strategy("Call XCreatePixmapCursor with mask pixmap.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap of size 1x1. */
	source = XCreatePixmap(display, DRW(display), 1, 1, 1);
	regid(display, (union regtypes *)&source, REG_PIXMAP);
/* Create mask pixmap of size 2x2. */
	mask = XCreatePixmap(display, DRW(display), 2, 2, 1);
	regid(display, (union regtypes *)&mask, REG_PIXMAP);

/* Call XCreatePixmapCursor with mask pixmap. */
	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that BadMatch error occurred. */
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XCreatePixmapCursor-11.(A)");
	report_assertion("When the hotspot position is not a point within the source");
	report_assertion("pixmap, then a BadMatch error occurs.");

	report_strategy("Create source pixmap.");
	report_strategy("Create mask pixmap.");
	report_strategy("Call XCreatePixmapCursor with hotspot outside the source pixmap.");
	report_strategy("Verify that BadMatch error occurred.");

	tpstartup();
	setargs();
	depth1.depth = 1;
/* Create source pixmap. */
	source = makepixm(display, &depth1);
/* Create mask pixmap. */
	mask = makepixm(display, &depth1);

	x = 2 * W_STDWIDTH + 1;
	y = 2 * W_STDHEIGHT + 1;

/* Call XCreatePixmapCursor with hotspot outside the source pixmap. */
	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that BadMatch error occurred. */
	if (geterr() == BadMatch)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t012(){

int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XCreatePixmapCursor-12.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EPix.mc */
/* End of included file error/EPix.mc */

/* Including from file error/EPix.mc */
static void t013(){

int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XCreatePixmapCursor-13.(A)");
	report_assertion("When a pixmap argument does not name a valid Pixmap, then a");
	report_assertion("BadPixmap error occurs.");

	report_strategy("Create a bad pixmap by creating and freeing a pixmap.");
	report_strategy("Call test function using bad pixmap as the pixmap argument.");
	report_strategy("Verify that a BadPixmap error occurs.");

	tpstartup();
	setargs();

	seterrdef();

	A_PIXMAP = (Pixmap) badpixm(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XCreatePixmapCursor(display, source, mask, foreground_color, background_color, x, y);
	endcall(display);
	if (geterr() != BadPixmap) {
		report("Got %s, Expecting BadPixmap", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadPixmap)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EPix.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
