/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XParseColor(display, colormap, spec, exact_def_return)
 *   Display		*display;
 *   Colormap	colormap;
 *   char		*spec;
 *   XColor		*exact_def_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XParseColor	1
char    *TestName = "XParseColor";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XParseColor function
 */
static Display		*display;
static Colormap	colormap;
static char		*spec;
static XColor		*exact_def_return;


static int 	StatusReturn;


#include	<ctype.h>

XColor		color_ret;

Status
checkcolor( red, green, blue, shift, ret_desired)
unsigned int	red, green, blue;
unsigned int	shift;
XColor		*ret_desired;
{
	ret_desired->red = (unsigned short) red<<shift;
	ret_desired->green = (unsigned short) green<<shift;
	ret_desired->blue = (unsigned short) blue<<shift;
	return((ret_desired->red == color_ret.red) && (ret_desired->green == color_ret.green) && (ret_desired->blue == color_ret.blue));
}

rgb_report(desired)
XColor	*desired;
{
	report("%s() returned red 0x%x green 0x%x blue 0x%x instead of red 0x%x green 0x%x blue 0x%x.",  
		TestName,
		(int) color_ret.red, (int) color_ret.green, (int) color_ret.blue,
		(int) desired->red, (int) desired->green, (int) desired->blue);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(Dsp, 0);
	spec = config.good_colorname;
	exact_def_return = &color_ret;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Status result;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XParseColor-1.(B)");
	report_assertion("When the first character of the spec argument is not #,");
	report_assertion("then a call to XParseColor returns in the exact_def_return");
	report_assertion("argument the rgb values for the colour named by the spec");
	report_assertion("argument on the screen associated with the colormap argument");
	report_assertion("and returns non-zero.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Parse the color XT_GOOD_COLORNAME using XParseColor.");
	report_strategy("Verify that the call returns non-zero.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	result = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(result == 0) {
		report("%s() returned zero.", TestName);
		FAIL;
	} else
		CHECK;

	CHECKUNTESTED(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Status	ret;
XColor	dcol;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XParseColor-2.(A)");
	report_assertion("When the first character of the spec argument is a, and");
	report_assertion("the remainder of the string comprises 3 hexadecimal digits,");
	report_assertion("then a call to XParseColor sets the exact_def_return");
	report_assertion("argument to have red component equal to the value of the");
	report_assertion("first digit << 12, to have green component equal to the");
	report_assertion("value of the second digit << 12, to have blue component");
	report_assertion("equal to the value of the third digit << 12 and returns");
	report_assertion("non-zero.");

	report_strategy("Parse the string \"#18f\" using XParseColor.");
	report_strategy("Verify that the returned XColor structure had red 0x1 green 0x8 blue 0xf.");

	tpstartup();
	setargs();
	spec = "#18f";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if( checkcolor(0x1, 0x8, 0xf, 12, &dcol) == 0) {
		rgb_report(&dcol);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Status	ret;
XColor	dcol;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XParseColor-3.(A)");
	report_assertion("When the first character of the spec argument is a, and");
	report_assertion("the remainder of the string comprises 6 hexadecimal digits,");
	report_assertion("then a call to XParseColor sets the exact_def_return");
	report_assertion("argument to have red component equal to the value of the");
	report_assertion("first two digits << 8, to have green component equal to the");
	report_assertion("value of the second two digits << 8, to have blue component");
	report_assertion("equal to the value of the third two digits << 8 and returns");
	report_assertion("non-zero.");

	report_strategy("Parse the string \"#f1f8ff\" using XParseColor.");
	report_strategy("Verify that the returned XColor structure had red 0xf1 green 0xf8 blue 0xff.");

	tpstartup();
	setargs();
	spec = "#f1f8ff";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if( checkcolor(0xf1, 0xf8, 0xff, 8, &dcol) == 0) {
		rgb_report(&dcol);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Status	ret;
XColor	dcol;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XParseColor-4.(A)");
	report_assertion("When the first character of the spec argument is a, and");
	report_assertion("the remainder of the string comprises 9 hexadecimal digits,");
	report_assertion("then a call to XParseColor sets the exact_def_return");
	report_assertion("argument to have red component equal to the value of the");
	report_assertion("first three digits << 4, to have green component equal to");
	report_assertion("the value of the second three digits << 4, to have blue");
	report_assertion("component equal to the value of the third three digits << 4");
	report_assertion("and returns non-zero.");

	report_strategy("Parse the string \"#af1bf8cff\" using XParseColor.");
	report_strategy("Verify that the returned XColor structure had red 0xaf1 green 0xbf8 blue 0xcff.");

	tpstartup();
	setargs();
	spec = "#af1bf8cff";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if( checkcolor(0xaf1, 0xbf8, 0xcff, 4, &dcol) == 0) {
		rgb_report(&dcol);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Status	ret;
XColor	dcol;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XParseColor-5.(A)");
	report_assertion("When the first character of the spec argument is a, and");
	report_assertion("the remainder of the string comprises 12 hexadecimal digits,");
	report_assertion("then a call to XParseColor sets the exact_def_return");
	report_assertion("argument to have red component equal to the value of the");
	report_assertion("first four digits, to have green component equal to the");
	report_assertion("value of the second four digits, to have blue component");
	report_assertion("equal to the value of the third four digits and returns");
	report_assertion("non-zero.");

	report_strategy("Parse the string \"#faf01bf81cff\" using XParseColor.");
	report_strategy("Verify that the returned XColor structure had red 0xfaf0 green 0x1bf8 blue 0x1cff.");

	tpstartup();
	setargs();
	spec = "#faf01bf81cff";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if( checkcolor(0xfaf0, 0x1bf8, 0x1cff, 0, &dcol) == 0) {
		rgb_report(&dcol);
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

char		*ptr;
char		*str;
Status		result;
XColor		dcol;
unsigned short	red, green, blue;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XParseColor-6.(A)");
	report_assertion("Upper and lower case characters in the spec argument refer");
	report_assertion("to the same colour.");

	report_strategy("Parse the string XT_GOOD_COLORNAME using XParseColor.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Parse the string obtained by inverting each character of XT_GOOD_COLORNAME using XParseColor.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that the returned red, green and blue values are the same.");
	report_strategy("Parse the string #feAAc1 using XParseColor.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Parse the string #FEAaC1 using XParseColor.");
	report_strategy("Verify that the call did not return zero.");
	report_strategy("Verify that the returned red, green and blue values are the same.");

	tpstartup();
	setargs();
	startcall(display);
	if (isdeleted())
		return;
	result = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(result == 0) {
		report("%s() with spec \"%s\" returned zero.", TestName, config.good_colorname);
		FAIL;
	} else
		CHECK;

	red = color_ret.red;
	green = color_ret.green;
	blue = color_ret.blue;

	str = xt_strdup(config.good_colorname);

	if(str == (char *) NULL) {
		delete("xt_strdup() returned NULL.");
		return;
	} else
		CHECK;

	for(ptr = str; *ptr; ptr++)
		if(isupper(*ptr)) 
			*ptr = tolower(*ptr);
		else
			*ptr = toupper(*ptr);
	
	spec = str;
	startcall(display);
	if (isdeleted())
		return;
	result = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(result == 0) {
		report("%s() with spec \"%s\" returned zero.", TestName, str);
		FAIL;
	} else
		CHECK;

	if((red != color_ret.red) || (green != color_ret.green) || (blue != color_ret.blue)) {
		report("%s() did not map color names %s and %s to the same rgb values.", TestName, config.good_colorname, str);
		FAIL;		
	} else
		CHECK;

	spec = "#feAAc1";
	startcall(display);
	if (isdeleted())
		return;
	result = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( result == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if( checkcolor(0xfe, 0xaa, 0xc1, 8, &dcol) == 0) {
		rgb_report(&dcol);
		FAIL;
	} else
		CHECK;

	spec = "#FEAaC1";
	startcall(display);
	if (isdeleted())
		return;
	result = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( result == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if( checkcolor(0xfe, 0xaa, 0xc1, 8, &dcol) == 0) {
		rgb_report(&dcol);
		FAIL;
	} else
		CHECK;

	CHECKPASS(8);


	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Status	ret;
char	flags;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XParseColor-7.(A)");
	report_assertion("A call to XParseColor sets the flags component of the");
	report_assertion("exact_def_return argument to DoRed|DoGreen|DoBlue.");

	report_strategy("Parse the string \"#000\" using XParseColor.");
	report_strategy("Verify that the flags component of the returned XColor structure was DoRed|DoGreen|DoBlue.");

	tpstartup();
	setargs();
	spec = "#000";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret == 0 ) {
		report("%s() with spec \"%s\" returned 0.", TestName, spec);
		FAIL;
	} else
		CHECK;

	if(color_ret.flags != (flags = DoRed | DoGreen | DoBlue)) {
		report("%s() set the flags component of the retured XColor structure to %d instead of DoRed|DoGreen|DoBlue (%d).",
			TestName, (int) color_ret.flags, (int) flags);

		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Status ret;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XParseColor-8.(A)");
	report_assertion("When the first character of the spec argument is a and the");
	report_assertion("remainder of the string does not comprise 3, 6, 9 or 12");
	report_assertion("hexadecimal digits, then a call to XParseColor returns zero.");

	report_strategy("Parse the string \"#f0\" using XParseColor.");
	report_strategy("Verify that the call returns zero.");
	report_strategy("Parse the string \"#1010\" using XParseColor.");
	report_strategy("Verify that the call returns zero.");
	report_strategy("Parse the string \"##ffeeffeeffe\" using XParseColor.");
	report_strategy("Verify that the call returns zero.");
	report_strategy("Parse the string \"##0011223344556\" using XParseColor.");
	report_strategy("Verify that the call returns zero.");

	tpstartup();
	setargs();
	spec = "#f0";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret != 0 ) {
		report("%s() with spec \"%s\" did not return zero.", TestName, spec);
		FAIL;
	} else
		CHECK;

	spec = "#1010";
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret != 0 ) {
		report("%s() with spec \"%s\" did not return zero.", TestName, spec);
		FAIL;
	} else
		CHECK;

	spec = "#ffeeffeeffe"; /* 11 digits */
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret != 0 ) {
		report("%s() with spec \"%s\" did not return zero.", TestName, spec);
		FAIL;
	} else
		CHECK;

	spec = "#0011223344556"; /* 13 digits */
	startcall(display);
	if (isdeleted())
		return;
	ret = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if( ret != 0 ) {
		report("%s() with spec \"%s\" did not return zero.", TestName, spec);
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Status		result;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XParseColor-9.(A)");
	report_assertion("When the first character of the spec argument is not a and");
	report_assertion("the colour named by the spec argument is not in the colour");
	report_assertion("database, then a call to XParseColor returns zero.");

	report_strategy("Parse the string XT_BAD_COLORNAME using XParseColor.");
	report_strategy("Verify that the call returns zero.");

	tpstartup();
	setargs();
	spec = config.bad_colorname;
	startcall(display);
	if (isdeleted())
		return;
	result = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(result != 0) {
		report("%s() with spec \"%s\" did not return zero.", TestName, config.bad_colorname);
		FAIL;
	} else
		PASS;

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t010(){

int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XParseColor-10.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XParseColor(display, colormap, spec, exact_def_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
