/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetDashes(display, gc, dash_offset, dash_list, n)
 *   Display *display;
 *   GC gc;
 *   int dash_offset;
 *   char *dash_list;
 *   int n;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetDashes	1
char    *TestName = "XSetDashes";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_GC gc


/*
 * Arguments to the XSetDashes function
 */
static Display *display;
static GC gc;
static int dash_offset;
static char *dash_list;
static int n;


char dashes[] = { 2, 1};
char odashes[] = {1, 3, 2};
char edashes[] = {1, 3, 2, 1, 3, 2};
char errdashes[] = {1, 0, 1};

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	gc = 0;
	dash_offset = 0;
	dash_list = dashes;
	n = sizeof(dashes)/sizeof(char);
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	gc = ErrdefGC;
}

static void t001(){

XVisualInfo *vp;
XGCValues values;
GC gc;
Window win;
int twidth;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetDashes-1.(A)");
	report_assertion("A call to XSetDashes sets the dash_offset and dash_list");
	report_assertion("attributes for dashed line styles in the specified GC to the");
	report_assertion("values of the dash_offset and dash_list arguments.");

	report_strategy("Create Window.");
	report_strategy("Create GC with dashes component = 1 , LineStyle = LineDoubleDash, fg = WhitePixel, bg = BlackPixel.");
	report_strategy("Set pixel at (1, 0) with XDrawPoint.");
	report_strategy("Draw line from (0, 0) to (2, 0) with XDrawLines.");
	report_strategy("Verify pixel at (1, 0) is bg using XGetImage and XGetpixel.");
	report_strategy("Set dashes component of GC to [2, 1] with XSetDashes.");
	report_strategy("Draw line from (0, 0) to (2, 0) using XDrawLine.");
	report_strategy("Verify pixel at (1, 0) is fg using XGetImage and XGetPixel.");

	tpstartup();
	setargs();
	for(twidth = 0; twidth < 2; twidth++) {
		resetvinf(VI_WIN);
		nextvinf(&vp);
		win = makewin(display, vp);

		values.foreground = W_FG;
		values.background = W_BG;
		values.line_style = LineDoubleDash;
		values.line_width = twidth;
		values.dashes = 1; /* [1, 1] */


		gc = XCreateGC(display, win, (GCLineWidth |GCLineStyle | GCDashList | GCForeground | GCBackground), &values);

		XDrawPoint(display, win, gc, 1, 0);
		XDrawLine(display, win, gc, 0, 0, 2, 0);

		if( ! checkpixel(display, win, 1, 0, W_BG)) {
			delete("Pixel at (1, 0) was not set to background (width %d)", twidth);
			return;
		} else
			CHECK;

		dash_offset = 0;
		dash_list= dashes;
		n = sizeof(dashes)/sizeof(char);
		startcall(display);
		if (isdeleted())
			return;
		XSetDashes(display, gc, dash_offset, dash_list, n);
		gcflush(A_DISPLAY, A_GC);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XDrawLine(display, win, gc, 0, 0, 2, 0);

		if( ! checkpixel(display, win, 1, 0, W_FG)) {
			report("Pixel at (1, 0) was not set to foreground (width %d)", twidth);			
			FAIL;
		} else
			CHECK;

	}
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo *vp;
GC gc;
XGCValues values;
Window win;
int twidth;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetDashes-2.(A)");
	report_assertion("The initial and alternate elements of the dash_list");
	report_assertion("argument specify the lengths of the even dashes and the");
	report_assertion("second and alternate elements specify the lengths of the odd");
	report_assertion("dashes.");

	report_strategy("For zero width and non-zero width lines:");
	report_strategy("    Create GC with line_style = LineDoubleDashed.");
	report_strategy("    Set dashes component of GC to [2, 1] with XSetDashes.");
	report_strategy("    Draw horizontal line from (0, 0) to (4, 0) using XDrawLine.");
	report_strategy("    Verify pixels at (0, 0) and (1, 0) are fg using XGetImage and XGetPixel.");
	report_strategy("    Verify pixel at (2, 0) is bg using XGetImage and XGetPixel.");
	report_strategy("    Verify pixel at (3, 0) is fg using XGetImage and XGetPixel.");
	report_strategy("    Draw vertical line from (0, 1) to (0, 5) using XDrawLine.");
	report_strategy("    Verify pixels at (0, 1) and (0, 2) are fg using XGetImage and XGetPixel.");
	report_strategy("    Verify pixel at (0, 3) is bg using XGetImage and XGetPixel.");
	report_strategy("    Verify pixel at (0, 4) is fg using XGetImage and XGetPixel.");

	tpstartup();
	setargs();

	for(twidth=0; twidth < 2; twidth++) {
		resetvinf(VI_WIN);
		nextvinf(&vp);
		win = makewin(display, vp);
	
		values.foreground = W_FG;
		values.background = W_BG;
		values.line_style = LineDoubleDash;
		values.line_width = twidth;
	
		gc = XCreateGC(display, win, (GCLineWidth | GCLineStyle | GCForeground | GCBackground ), &values);
	
		dash_offset = 0;
		dash_list = dashes;
		n = sizeof(dashes)/sizeof(char);
	
		startcall(display);
		if (isdeleted())
			return;
		XSetDashes(display, gc, dash_offset, dash_list, n);
		gcflush(A_DISPLAY, A_GC);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		XDrawLine(display, win, gc, 0, 0, 4, 0);
	
		if( (checkpixels(display, win, 0, 0, 1, 0, 2, W_FG) == True) &&
		    (checkpixel(display, win, 2, 0, W_BG) == True) &&
		    (checkpixel(display, win, 3, 0, W_FG) == True) )
			CHECK;
		else {
			report("Horizontal dashing incorrect for width %d.", twidth);
			FAIL;
		}

		XDrawLine(display, win, gc, 0, 1, 0, 5);
	
		if(  (checkpixels(display, win, 0, 1, 0, 1, 2, W_FG) == True) &&
		     (checkpixel(display, win, 0, 3, W_BG) == True) &&
		     (checkpixel(display, win, 0, 4, W_FG) == True) )
			 CHECK;
		 else {
			 report("Vertical dashing incorrect for width %d.", twidth);
			 FAIL;
		 }

	}
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo *vp;
XGCValues values;
XImage *image;
Window win;
int i;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetDashes-3.(A)");
	report_assertion("When an odd-length list is specified, then it is");
	report_assertion("concatenated with itself to produce an even-length list.");

	report_strategy("Create GC with line_style = LineDoubleDashed.");
	report_strategy("Set dashes component of GC to [1, 3, 2] with XSetDashes.");
	report_strategy("Draw horizontal line from (0, 0) to (10, 0) using XDrawLine.");
	report_strategy("Set dashes component of GC to [1, 3, 2, 1, 3, 2] with XSetDashes.");
	report_strategy("Draw horizontal line from (0, 1) to (10, 1) using XDrawLine.");
	report_strategy("Verify that the two lines are identical using XGetImage and XGetPixel.");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	win = makewin(display, vp);

	values.foreground = W_FG;
	values.background = W_BG;
	values.line_style = LineDoubleDash;
	gc = XCreateGC(display, win, (GCLineStyle | GCForeground | GCBackground), &values);

	dash_offset = 0;
	dash_list = odashes;
	n = sizeof(odashes)/sizeof(char);
	startcall(display);
	if (isdeleted())
		return;
	XSetDashes(display, gc, dash_offset, dash_list, n);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XDrawLine(display, win, gc, 0, 0, 10, 0);


	dash_offset = 0;
	dash_list = edashes;
	n = sizeof(edashes)/sizeof(char);
	startcall(display);
	if (isdeleted())
		return;
	XSetDashes(display, gc, dash_offset, dash_list, n);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XDrawLine(display, win, gc, 0, 1, 10, 1);

	image = XGetImage(display, win, 0, 0, 10, 2, AllPlanes, ZPixmap);

	for(i=0; i<10; i++)
		if(XGetPixel(image, i, 0) != XGetPixel(image, i, 1)) {
			report("Pixel at (%d,0) was not the same as pixel at (%d,1).", i, i);
			FAIL;
		} else
			CHECK;

	CHECKPASS(10);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetDashes-4.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

/* Including from file error/EGC.mc */
/* End of included file error/EGC.mc */

/* Including from file error/EGC.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XSetDashes-5.(A)");
	report_assertion("When the GC argument does not name a defined GC, then a");
	report_assertion("BadGC error occurs.");

	report_strategy("Create a GC.");
	report_strategy("Set GC id to -1 using XTestSetGContextOfGC.");
	report_strategy("Call test function using bad GC as the GC argument.");
	report_strategy("Verify that a BadGC error occurs.");

	tpstartup();
	setargs();
	seterrdef();


	A_GC = badgc(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XSetDashes(display, gc, dash_offset, dash_list, n);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		PASS;
	else
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EGC.mc */

static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XSetDashes-6.(A)");
	report_assertion("When the specified dash list is empty, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Call XSetDashes with dash_list set to NULL and n set to 0.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	gc = XCreateGC(display, DRW(display), 0L, (XGCValues*) 0);

	dash_offset = 0;
	dash_list = (char *)NULL;
	n = 0;
	startcall(display);
	if (isdeleted())
		return;
	XSetDashes(display, gc, dash_offset, dash_list, n);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadValue)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

int screen;
GC gc;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XSetDashes-7.(A)");
	report_assertion("When an element of the dash list is 0, then a BadValue");
	report_assertion("error occurs.");

	report_strategy("Set dashes component of GC to [1, 0, 1] with XSetDashes.");
	report_strategy("Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	screen = DefaultScreen(display);
	gc = XCreateGC(display, RootWindow(display, screen), 0L, (XGCValues*) 0);
	dash_offset = 0;
	dash_list = errdashes;
	n = sizeof(errdashes)/sizeof(char);
	startcall(display);
	if (isdeleted())
		return;
	XSetDashes(display, gc, dash_offset, dash_list, n);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if(geterr() == BadValue)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
