/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XSetFontPath(display, directories, ndirs)
 *   Display *display;
 *   char	**directories;
 *   int 	ndirs;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XSetFontPath	1
char    *TestName = "XSetFontPath";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XSetFontPath function
 */
static Display *display;
static char	**directories;
static int 	ndirs;



/*
 * Startup and cleanup code attempt to save and restore the Font path
 * over the tests. 
 * This should not be needed now because saving and restoring the Font path
 * is done in startup/cleanup - but it is still done here in case that
 * scheme is ever changed.
 */
static	char	**savepath;
static	int 	savenum;
static void
localstartup()
{
	startup();
	if(Dsp) {
		XSetErrorHandler(error_status);
		savepath = XGetFontPath(Dsp, &savenum);
		XSetErrorHandler(unexp_err);
	}
}
static void
localcleanup()
{
	if(Dsp) {
		if (savepath && savenum)
			XSetFontPath(Dsp, savepath, savenum);
		XSync(Dsp, 0);
	}
	cleanup();
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	directories = 0;
	ndirs = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char	*fpathlist;
char	*fpathtmp;
char	*dirlist[MAX_DIRS];
char	*strtok();
char	**checkpath;
int 	nret;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XSetFontPath-1.(A)");
	report_assertion("When XSetFontPath is called with the directories argument");
	report_assertion("specifying a list of directories in an operating system");
	report_assertion("dependent format, then the directory search path for font");
	report_assertion("lookup is set to the list of directories in the order");
	report_assertion("specified.");

	report_strategy("Get TET variable XT_FONTPATH_GOOD");
	report_strategy("Set font path to this value.");
	report_strategy("Do simple check with XGetFontPath.");

	tpstartup();
	setargs();
	fpathlist = tet_getvar("XT_FONTPATH_GOOD");
	if (fpathlist == NULL || *fpathlist == '\0') {
		delete("XT_FONTPATH_GOOD not set in config file");
		return;
	}
	fpathtmp = (char *)calloc(strlen(fpathlist)+1, sizeof(char));
	strcpy(fpathtmp, fpathlist);

	for (i = 0; i < MAX_DIRS; i++) {
		dirlist[i] = strtok((i==0)? fpathtmp: (char*)0, SEP);
		if (dirlist[i] == NULL)
			break;
		debug(1, "dirlist entry %d - '%s'", i, dirlist[i]);
	}
	directories = dirlist;
	ndirs = i;

	if (ndirs <= 0) {
		delete("No components in supplied XT_FONTPATH_GOOD");
		return;
	}

	startcall(display);
	if (isdeleted())
		return;
	XSetFontPath(display, directories, ndirs);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	checkpath = XGetFontPath(display, &nret);
	if (nret == ndirs)
		CHECK;
	else {
		report("Different number of directories returned");
		report("  was %d, expecting %d", nret, ndirs);
		FAIL;
	}

	if (ndirs < nret)
		nret = ndirs;
	for (i = 0; i < nret; i++) {
		debug(1, "got back list item '%s'", checkpath[i]);
		if (strcmp(dirlist[i], checkpath[i]) == 0)
			CHECK;
		else {
			report("Font path component did not match what was set");
			report("  was '%s', expecting '%s'", checkpath[i], dirlist[i]);
			FAIL;
		}
	}

	CHECKPASS(1+ndirs);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*client2;
char	*fpathlist;
char	*fpathtmp;
char	*dirlist[MAX_DIRS];
char	*strtok();
char	**checkpath;
int 	nret;
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XSetFontPath-2.(A)");
	report_assertion("On a call to XSetFontPath, the directory search path for");
	report_assertion("font lookup is set for all clients.");

	report_strategy("Open a second client.");
	report_strategy("Set font path in first client.");
	report_strategy("Get font path in the second client.");
	report_strategy("Verify that the font is the same in each client.");

	tpstartup();
	setargs();
	client2 = XOpenDisplay(DisplayString(display));
	if (client2 == NULL || isdeleted()) {
		delete("Could not open second client");
		return;
	}

	fpathlist = tet_getvar("XT_FONTPATH_GOOD");
	if (fpathlist == NULL || *fpathlist == '\0') {
		delete("XT_FONTPATH_GOOD not set in config file");
		return;
	}
	fpathtmp = (char *)calloc(strlen(fpathlist)+1, sizeof(char));
	strcpy(fpathtmp, fpathlist);

	for (i = 0; i < MAX_DIRS; i++) {
		dirlist[i] = strtok((i==0)? fpathtmp: (char*)0, SEP);
		if (dirlist[i] == NULL)
			break;
		debug(1, "dirlist entry %d - '%s'", i, dirlist[i]);
	}
	directories = dirlist;
	ndirs = i;

	if (ndirs <= 0) {
		delete("No components in supplied XT_FONTPATH_GOOD");
		return;
	}

	startcall(display);
	if (isdeleted())
		return;
	XSetFontPath(display, directories, ndirs);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	checkpath = XGetFontPath(client2, &nret);
	if (nret == ndirs)
		CHECK;
	else {
		report("Different number of directories returned");
		report("  was %d, expecting %d", nret, ndirs);
		FAIL;
	}

	if (ndirs < nret)
		nret = ndirs;
	for (i = 0; i < nret; i++) {
		debug(1, "got back list item '%s'", checkpath[i]);
		if (strcmp(dirlist[i], checkpath[i]) == 0)
			CHECK;
		else {
			report("Font path component did not match what was set");
			report("  was '%s', expecting '%s'", checkpath[i], dirlist[i]);
			FAIL;
		}
	}

	CHECKPASS(1+ndirs);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.26994 */
static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XSetFontPath-3.(B)");
	report_assertion("On a call to XSetFontPath, the X server flushes all cached");
	report_assertion("information about fonts for which there are currently no");
	report_assertion("explicit resource ID's allocated.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.26994 */

static void t004(){

char	*fpathlist;
char	*dirlist[MAX_DIRS];
char	*strtok();
int 	i;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XSetFontPath-4.(C)");
	report_assertion("When the directories argument is invalid for the operating");
	report_assertion("system, then a BadValue error occurs.");

	report_strategy("Get TET variable XT_FONTPATH_BAD");
	report_strategy("If this is set to UNSUPPORTED, then no bad paths are possible");
	report_strategy("  result is UNSUPPORTED");
	report_strategy("Set font path to this value.");
	report_strategy("Verify that BadValue error is generated.");

	tpstartup();
	setargs();
	fpathlist = tet_getvar("XT_FONTPATH_BAD");
	if (fpathlist == NULL || *fpathlist == '\0') {
		delete("XT_FONTPATH_BAD not set in config file");
		return;
	}
	if (strcmp(fpathlist, "UNSUPPORTED") == 0) {
		report("No bad paths are possible");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	for (i = 0; i < MAX_DIRS; i++) {
		dirlist[i] = strtok((i==0)? fpathlist: (char*)0, SEP);
		if (dirlist[i] == NULL)
			break;
	}
	directories = dirlist;
	ndirs = i;

	if (ndirs <= 0) {
		delete("No components in supplied XT_FONTPATH_BAD");
		return;
	}

	startcall(display);
	if (isdeleted())
		return;
	XSetFontPath(display, directories, ndirs);
	endcall(display);
	if (geterr() != BadValue) {
		report("Got %s, Expecting BadValue", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadValue)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = localstartup;
void	(*tet_cleanup)() = localcleanup;
