/*
 * Copyright © 2007 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * Authors:
 *    Eric Anholt <eric@anholt.net>
 *
 */

/**
 * @file bsd_pci.c
 *
 * This is a trivial implementation of the remaining PCI support hooks in the
 * X Server that is unaware of domains.
 *
 * Most of even this should go away once drivers are converted and the
 * old interfaces are confirmed to all be obsolete.
 */

#ifdef HAVE_XORG_CONFIG_H
#include <xorg-config.h>
#endif

#include <stdio.h>
#include "compiler.h"
#include "xf86.h"
#include "xf86Priv.h"
#include "xf86_OSlib.h"
#include "Pci.h"

#include "pciaccess.h"

static pciBusFuncs_t bsd_funcs = {
    .pciAddrBusToHost = pciAddrNOOP,
};

static pciBusInfo_t bsd_pci = {
    .configMech = PCI_CFG_MECH_OTHER,
    .numDevices = 32,
    .secondary = FALSE,
    .primary_bus = 0,
    .funcs = &bsd_funcs,
    .pciBusPriv = NULL,
    .bridge = NULL,
};

_X_EXPORT pointer
xf86MapDomainMemory(int ScreenNum, int Flags, struct pci_device *dev,
		    ADDRESS Base, unsigned long Size)
{
    return xf86MapVidMem(ScreenNum, Flags, Base, Size);
}

IOADDRESS
xf86MapLegacyIO(struct pci_device *dev)
{
    (void)dev;
    return 0;
}

void
bsdPciInit(void)
{
    pciNumBuses = 1;
    pciBusInfo[0] = &bsd_pci;

    xf86InitVidMem();
}
