/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_LeaveNotify	1
char    *TestName = "LeaveNotify";



#define	EVENT		LeaveNotify
#define	OTHEREVENT	EnterNotify
#define	MASK		LeaveWindowMask
#define	OTHERMASK	EnterWindowMask
#define	BOTHMASKS	(MASK|OTHERMASK)
#define EVENTMASK	MASK

static	Display	*_display_;
static	int	_detail_;
static	long	_event_mask_;
static	XEvent	good;

static	int
selectinput(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	return(winh_selectinput(_display_, current, _event_mask_));
}

static	int
plant(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	good.xany.window = current->window;
	return(winh_plant(current, &good, NoEventMask, WINH_NOMASK));
}

static	Bool	increasing;	/* event sequence increases as we climb */

static	int
checksequence(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
	Winhe	*d;
	int	current_sequence;
	int	status;
	static	int	last_sequence;

#ifdef	lint
	winh_free(start);
	winh_free(stop);
#endif
	/* look for desired event type */
	for (d = current->delivered; d != (Winhe *) NULL; d = d->next) {
		if (d->event->type == good.type) {
			current_sequence = d->sequence;
			break;
		}
	}
	if (d == (Winhe *) NULL) {
		report("%s event not delivered", eventname(good.type));
		delete("Missing event");
		return(-1);
	}
	if (previous == (Winh *) NULL)
		status = 0;	/* first call, no previous sequence value */
	else {
		/* assume sequence numbers are not the same */
		status = (current_sequence < last_sequence);
		if (increasing)
			status = (status ? 0 : 1);
		if (status)
			report("Ordering problem between 0x%x (%d) and 0x%x (%d)",
				current->window, current_sequence,
				previous->window, last_sequence);
	}
	last_sequence = current_sequence;
	return(status);
}

static	int
checkdetail(start, stop, current, previous)
Winh	*start, *stop, *current, *previous;
{
	Winhe	*d;

#ifdef	lint
	winh_free(start);
	winh_free(stop);
	winh_free(previous);
#endif
	/* look for desired event type */
	for (d = current->delivered; d != (Winhe *) NULL; d = d->next)
		if (d->event->type == good.type)
			break;
	if (d == (Winhe *) NULL) {
		report("%s event not delivered to window 0x%x",
			eventname(good.type), current->window);
		delete("Missing event");
		return(-1);
	}
	/* check detail */
	if (_detail_ != d->event->xcrossing.detail) {
		report("Expected detail of %d, got %d on window 0x%x",
			_detail_, d->event->xcrossing.detail, current->window);
		return(1);
	}
	return(0);
}

int 	tet_thistest;

static void t001(){

int	i;
Display	*display = Dsp;
Window	w2;
XEvent	event;
struct area	area;
PointerPlace	*warp;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion LeaveNotify-1.(A)");
	report_assertion("When a LeaveNotify event is generated by a hierarchy");
	report_assertion("change, then the LeaveNotify event is delivered after any");
	report_assertion("hierarchy event.");

	report_strategy("Create window1.");
	report_strategy("Create window2 on top of window1.");
	report_strategy("Select for LeaveNotify and UnmapNotify events on window2.");
	report_strategy("Move pointer to window2.");
	report_strategy("Call XUnmapWindow on window2.");
	report_strategy("Verify that UnmapNotify event was received on window2.");
	report_strategy("Verify that LeaveNotify event was received on window1.");
	report_strategy("Verify that pointer has remained where it was moved.");

	tpstartup();
/* Create window1. */
	area.x = 0;
	area.y = 0;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Create window2 on top of window1. */
	w2 = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Select for xname and UnmapNotify events on window2. */
	XSelectInput(display, w2, MASK|StructureNotifyMask);
/* Move pointer to window2. */
	warp = warppointer(display, w2, 0, 0);
	if (warp == (PointerPlace *) NULL)
		return;
	else
		CHECK;
	XSync(display, True);
/* Call XUnmapWindow on window2. */
	XUnmapWindow(display, w2);
	XSync(display, False);
/* Verify that UnmapNotify event was received on window2. */
	if (XPending(display) < 1) {
		report("Expected UnmapNotify event not delivered.");
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(display, &event);
	if (event.type != UnmapNotify) {
		report("Expected %s, got %s", eventname(UnmapNotify), eventname(event.type));
		FAIL;
	}
	else
		CHECK;
/* Verify that xname event was received on window1. */
	if (XPending(display) < 1) {
		report("Expected %s event not delivered.", TestName);
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(display, &event);
	if (event.type != EVENT) {
		report("Expected %s, got %s", eventname(EVENT), eventname(event.type));
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(display)) > 0) {
		report("Expected 2 events, got %d", i+2);
		FAIL;
	}
	else
		CHECK;

	/* Additional possible testing: */
	/* Select for no events on window1. */
	/* Select for MapNotify events on window2. */
	/* Select for xname events on window2. */
	/* Select for xname events on window2 with client2. */
	/* Call XMapWindow on window2. */
	/* Verify that MapNotify event was received on window2. */
	/* Verify that xname event was received on window2. */
	/* Verify that xname event was received on window2 by client2. */
	/* Verify that pointer has remained where it was moved. */
	/* Select for xname events on window1. */
	/* Select for xname events on window1 with client2. */
	/* Select for ConfigureNotify events on window2. */
	/* Call XLowerWindow on window2. */
	/* Verify that ConfigureNotify event was received on window2. */
	/* Verify that xname event was received on window1. */
	/* Verify that xname event was received on window1 by client2. */
	/* Verify that pointer has remained where it was moved. */

	/* Others: GravityNotify, CirculateNotify. */

/* Verify that pointer has remained where it was moved. */
	if (pointermoved(display, warp)) {
		delete("Pointer moved unexpectedly");
		return;
	}
	else
		CHECK;
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	i;
Display	*display = Dsp;
Display	*client2, *client3;
Window	w;
XEvent	event;
XLeaveWindowEvent	good;
struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion LeaveNotify-2.(A)");
	report_assertion("When a LeaveNotify event is generated, then all clients");
	report_assertion("having set LeaveWindowMask event mask bits on the event");
	report_assertion("window are delivered a LeaveNotify event.");

	report_strategy("Create clients client2 and client3.");
	report_strategy("Create window.");
	report_strategy("Move pointer inside of window.");
	report_strategy("Select for LeaveNotify events on window.");
	report_strategy("Select for LeaveNotify events on window with client2.");
	report_strategy("Select for no events on window with client3.");
	report_strategy("Warp pointer outside window.");
	report_strategy("Verify that a single LeaveNotify event was received.");
	report_strategy("Verify that a single LeaveNotify event was received by client2.");
	report_strategy("Verify that no events were received by client2.");

	tpstartup();
/* Create clients client2 and client3. */
	if ((client2 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client2.");
		return;
	}
	else
		CHECK;
	if ((client3 = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client3.");
		return;
	}
	else
		CHECK;
/* Create window. */
	area.x = 10;
	area.y = 10;
	area.width = W_STDWIDTH;
	area.height = W_STDHEIGHT;
	w = mkwin(display, (XVisualInfo *) NULL, &area, True);
/* Move pointer inside of window. */
	if (warppointer(display, w, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select for xname events on window. */
	XSelectInput(display, w, MASK);
/* Select for xname events on window with client2. */
	XSelectInput(client2, w, MASK);
/* Select for no events on window with client3. */
	XSelectInput(client3, w, NoEventMask);
/* Warp pointer outside window. */
	XSync(display, True);
	XSync(client2, True);
	XSync(client3, True);
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	XSync(client2, False);
	XSync(client3, False);
/* Verify that a single xname event was received. */
	if (XPending(display) < 1) {
		report("Expected %s event not delivered.", TestName);
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(display, &event);
	good = event.xcrossing;
	good.type = EVENT;
	good.send_event = False;
	good.display = display;
	good.window = w;
	good.root = DRW(display);
	good.subwindow = None;
	rootcoordset(display, DRW(display), w, 0, 0, &(good.x), &(good.y));
	good.x_root = 0;
	good.y_root = 0;
	good.mode = NotifyNormal;
	/* under virtual root windows detail gets set to NotifyNonlinear */
	good.detail = NotifyAncestor;
	good.same_screen = True;
	good.focus = True;	/* assumes focus follows pointer */
	good.state = 0;
	if (checkevent((XEvent*)&good, &event)) {
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(display)) > 0) {
		report("Expected 1 event, got %d", i+1);
		FAIL;
	}
	else
		CHECK;
/* Verify that a single xname event was received by client2. */
	if (XPending(client2) < 1) {
		report("Expected %s event not delivered to client2.", TestName);
		FAIL;
		return;
	}
	else
		CHECK;
	XNextEvent(client2, &event);
	good = event.xcrossing;
	good.type = EVENT;
	good.send_event = False;
	good.display = client2;
	good.window = w;
	good.root = DRW(client2);
	good.subwindow = None;
	rootcoordset(client2, DRW(client2), w, 0, 0, &(good.x), &(good.y));
	good.x_root = 0;
	good.y_root = 0;
	good.mode = NotifyNormal;
	/* under virtual root windows detail gets set to NotifyNonlinear */
	good.detail = NotifyAncestor;
	good.same_screen = True;
	good.focus = True;	/* assumes focus follows pointer */
	good.state = 0;
	if (checkevent((XEvent*)&good, &event)) {
		report("Unexpected structure member values for client2");
		FAIL;
	}
	else
		CHECK;
	if ((i = XPending(client2)) > 0) {
		report("Expected 1 event, got %d for client2", i+1);
		FAIL;
	}
	else
		CHECK;
/* Verify that no events were received by client2. */
	if ((i = XPending(client2)) > 0) {
		report("For client2: Expected 0 events, got %d", i);
		FAIL;
	}
	else
		CHECK;
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){


 	report_purpose(3);

	report_assertion("Assertion LeaveNotify-3.(-)");
	report_assertion("When a LeaveNotify event is generated, then clients not");
	report_assertion("having set LeaveWindowMask event mask bits on the event");
	report_assertion("window are not delivered a LeaveNotify event.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t004(){

int	status;
Display	*display = Dsp;
Winh	*eventw;
Winh	*child;
XEvent	good;
Winhg	winhg;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion LeaveNotify-4.(A)");
	report_assertion("When a LeaveNotify event is delivered and the child of the");
	report_assertion("event window contains the initial pointer position, then");
	report_assertion("subwindow is set to that child.");

	report_strategy("Build window hierarchy.");
	report_strategy("Create the hierarchy.");
	report_strategy("Move pointer to inside of child window.");
	report_strategy("Set LeaveWindowMask event mask bits on the eventw.");
	report_strategy("Move pointer to outside  of windows.");
	report_strategy("Verify that a LeaveNotify event was received.");
	report_strategy("Verify that subwindow is set to the source window.");

	tpstartup();
/* Build window hierarchy. */
	winhg.area.x = 10;
	winhg.area.y = 10;
	winhg.area.width = W_STDWIDTH;
	winhg.area.height = W_STDHEIGHT;
	winhg.border_width = 1;
	eventw = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (eventw == (Winh *) NULL) {
		report("Could not create eventw");
		return;
	}
	else
		CHECK;
	winhg.area.width /= 2;
	winhg.area.height /= 2;
	child = winh_adopt(display, eventw, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (child == (Winh *) NULL) {
		report("Could not create child");
		return;
	}
	else
		CHECK;
/* Create the hierarchy. */
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Move pointer to inside of child window. */
	if (warppointer(display, child->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set LeaveWindowMask event mask bits on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
/* Move pointer to outside  of windows. */
	XSync(display, True);
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify that a xname event was received. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = eventw->window;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK))
		return;
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that subwindow is set to the source window. */
		/* since only one event was expected, it must be first in list */
		if (eventw->delivered->event->xcrossing.subwindow != child->window) {
			report("Subwindow set to 0x%x, expected 0x%x",
				eventw->delivered->event->xcrossing.subwindow, child->window);
			FAIL;
		}
		else
			CHECK;
	}

	CHECKPASS(8);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

int	status;
Display	*display = Dsp;
Winh	*eventw;
XEvent	good;
Winhg	winhg;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion LeaveNotify-5.(A)");
	report_assertion("When a LeaveNotify event is delivered and the child of the");
	report_assertion("event window does not contain the initial pointer position,");
	report_assertion("then subwindow is set to None.");

	report_strategy("Build window hierarchy.");
	report_strategy("Create the hierarchy.");
	report_strategy("Move pointer to inside of window.");
	report_strategy("Set LeaveWindowMask event mask bits on the eventw.");
	report_strategy("Move pointer to outside  of windows.");
	report_strategy("Verify that a LeaveNotify event was received.");
	report_strategy("Verify that subwindow is set to None.");
	report_strategy("  since only one event was expected, it must be first in list");

	tpstartup();
/* Build window hierarchy. */
	winhg.area.x = 10;
	winhg.area.y = 10;
	winhg.area.width = W_STDWIDTH;
	winhg.area.height = W_STDHEIGHT;
	winhg.border_width = 1;
	eventw = winh_adopt(display, (Winh *) NULL, 0L, (XSetWindowAttributes *) NULL, &winhg, WINH_NOMASK);
	if (eventw == (Winh *) NULL) {
		report("Could not create eventw");
		return;
	}
	else
		CHECK;
/* Create the hierarchy. */
	if (winh_create(display, (Winh *) NULL, WINH_MAP))
		return;
	else
		CHECK;
/* Move pointer to inside of window. */
	if (warppointer(display, eventw->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set LeaveWindowMask event mask bits on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
/* Move pointer to outside  of windows. */
	XSync(display, True);
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify that a xname event was received. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = eventw->window;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK))
		return;
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL))
		return;
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that subwindow is set to None. */
		/* since only one event was expected, it must be first in list */
		if (eventw->delivered->event->xcrossing.subwindow != None) {
			report("Subwindow set to 0x%x, expected 0x%x",
				eventw->delivered->event->xcrossing.subwindow, None);
			FAIL;
		}
		else
			CHECK;
	}

	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Window		w;
Window		w2;
XEvent		ev;
int		gr;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion LeaveNotify-6.(C)");
	report_assertion("If multiple screens are supported: When a LeaveNotify event");
	report_assertion("is delivered and the event and root windows are not on the");
	report_assertion("same screen, then x and y are set to zero.");

	report_strategy("If multiple screens are supported:");
	report_strategy("  Create a window on the default screen.");
	report_strategy("  Create a window on the alternate screen.");
	report_strategy("  Warp the pointer into the first window.");
	report_strategy("  Grab the pointer for the first window.");
	report_strategy("  Warp the pointer to the alternate window.");
	report_strategy("  Verify that an LeaveNotify event was generated relative to the grab window.");
	report_strategy("  Verify that the x and y components of the event were set to zero.");

	tpstartup();

	/* If multiple screens are supported: */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

			/* Create a window on the default screen. */
        w = defwin(Dsp);
	
			/* Create a window on the alternate screen. */
	w2 = defdraw(Dsp, VI_ALT_WIN);

			/* Warp the pointer into the first window. */
	warppointer(Dsp, w, 2,3);

			/* Grab the pointer for the first window. */
	if((gr=XGrabPointer(Dsp, w, False, EVENTMASK, GrabModeAsync, GrabModeAsync, None, None, CurrentTime)) != GrabSuccess) {
		delete("XGrabPointer() returned %s instead of GrabSuccess.", grabreplyname(gr));
		return;
	} else
		CHECK;

			/* Warp the pointer to the alternate window. */
	XSync(Dsp, True);
	warppointer(Dsp, w2, 1,1);
	XSync(Dsp, False);

			/* Verify that an xname event was generated relative to the grab window. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

			/* Verify that the x and y components of the event were set to zero. */
		if(ev.xcrossing.x != 0 || ev.xcrossing.y != 0) {
			report("The x (value %d) and y (value %d) components of the %s event were not set to zero.",
				 ev.xcrossing.x, ev.xcrossing.y, eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabPointer(Dsp, CurrentTime);
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){


 	report_purpose(7);

	report_assertion("Assertion LeaveNotify-7.(-)");
	report_assertion("All LeaveNotify events are delivered before any related");
	report_assertion("EnterNotify events are delivered.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t008(){

Display	*display = Dsp;
int	depth = 4;
Winh	*A, *B;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion LeaveNotify-8.(A)");
	report_assertion("When the pointer moves from window A to window B and A is");
	report_assertion("an inferior of B, then a LeaveNotify event is generated on");
	report_assertion("window A with detail set to NotifyAncestor and then on each");
	report_assertion("window between window A and window B, exclusive, with detail");
	report_assertion("set to NotifyVirtual.");

	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window B.");
	report_strategy("Set window A to child of window B.");
	report_strategy("Select for EnterNotify and LeaveNotify events on windows A and B.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify that the expected events were delivered.");
	report_strategy("Verify that event delivered to window A with detail set to NotifyAncestor.");
	report_strategy("Verify events delivered, between window A and window B, exclusive,");
	report_strategy("in proper order.");
	report_strategy("Verify that detail is set to NotifyVirtual.");
	report_strategy("Verify that all LeaveNotify events are delivered before all");
	report_strategy("EnterNotify events.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window B. */
	B = guardian->firstchild;
/* Set window A to child of window B. */
	A = B->firstchild->firstchild->firstchild;
/* Select for EnterNotify and xname events on windows A and B. */
	_event_mask_ = BOTHMASKS;
	_display_ = display;
	if (winh_climb(A, B, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(A, B->firstchild, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify that the expected events were delivered. */
	if (winh_ignore_event(B, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to window A with detail set to NotifyAncestor. */
		_detail_ = NotifyAncestor;
		if (winh_climb(A, A, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify events delivered, between window A and window B, exclusive, */
/* in proper order. */
		increasing = False;
		if (winh_climb(A, B->firstchild, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that detail is set to NotifyVirtual. */
		_detail_ = NotifyVirtual;
		if (winh_climb(A->parent, B->firstchild, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* EnterNotify events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Display	*display = Dsp;
int	depth = 3;
Winh	*A, *B;
int	status;
XEvent	*event;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion LeaveNotify-9.(A)");
	report_assertion("When the pointer moves from window A to window B and B is");
	report_assertion("an inferior of A, then a LeaveNotify event is generated on");
	report_assertion("window A with detail set to NotifyInferior.");

	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set window A.");
	report_strategy("Set window B to child of window A.");
	report_strategy("Select for LeaveNotify and EnterNotify events on windows A and B.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify LeaveNotify event received on window A.");
	report_strategy("Verify that detail is set to NotifyInferior.");
	report_strategy("Verify that all LeaveNotify events are delivered before all");
	report_strategy("EnterNotify events.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set window A. */
	A = guardian->firstchild;
/* Set window B to child of window A. */
	B = A->firstchild;
/* Select for xname and EnterNotify events on windows A and B. */
	if (winh_selectinput(display, A, BOTHMASKS)) {
		report("Error selecting for events.");
		return;
	}
	else
		CHECK;
	if (winh_selectinput(display, B, BOTHMASKS)) {
		report("Error selecting for events.");
		return;
	}
	else
		CHECK;

/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
/* Verify xname event received on window A. */
	if (A->delivered == (Winhe *) NULL || (event = A->delivered->event)->type != EVENT) {
		report("Expected event not generated");
		FAIL;
	}
	else
	{
/* Verify that detail is set to NotifyInferior. */
		if (event->xcrossing.detail != NotifyInferior) {
			report("Got detail %d, expected %d", event->xcrossing.detail, NotifyInferior);
			FAIL;
		}
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* EnterNotify events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status)
			FAIL;
		else
			CHECK;
	}
	CHECKPASS(7);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Display	*display = Dsp;
int	depth = 5;
Winh	*A, *B, *C;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion LeaveNotify-10.(A)");
	report_assertion("When the pointer moves from window A to window B and there");
	report_assertion("exists a window C that is their least common ancestor, then");
	report_assertion("a LeaveNotify event is generated on window A with detail set");
	report_assertion("to NotifyNonlinear and then on each window between window A");
	report_assertion("and window C, exclusive, with detail set to");
	report_assertion("NotifyNonlinearVirtual.");

	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to known location.");
	report_strategy("Set windows A, B, and C.");
	report_strategy("Select for LeaveNotify and EnterNotify events on window A and");
	report_strategy("between windows A and C, exclusive.");
	report_strategy("Select for LeaveNotify and EnterNotify events between windows B and C.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify that event delivered to window A with detail set to NotifyNonlinear.");
	report_strategy("Verify events delivered in proper order.");
	report_strategy("Verify that detail is set to NotifyNonlinearVirtual on events delivered on");
	report_strategy("each window between window A and window C, exclusive.");
	report_strategy("Verify that all LeaveNotify events are delivered before all");
	report_strategy("EnterNotify events.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Move pointer to known location. */
	if (warppointer(display, DRW(display), 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Set windows A, B, and C. */
	C = guardian->firstchild;
	A = C->firstchild->nextsibling->firstchild->firstchild;
	B = C->firstchild->             firstchild->firstchild;
/* Select for xname and EnterNotify events on window A and */
/* between windows A and C, exclusive. */
	_event_mask_ = BOTHMASKS;
	_display_ = display;
	if (winh_climb(A, C->firstchild->nextsibling, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
/* Select for xname and EnterNotify events between windows B and C. */
	_display_ = display;
	if (winh_climb(B, C, selectinput)) {
		report("Could not select for events between C and B");
		return;
	}
	else
		CHECK;
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(A, C->firstchild->nextsibling, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XWarpPointer(display, None, A->window, 0, 0, 0, 0, 0, 0);
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event((Winh *) NULL, OTHEREVENT, WINH_NOMASK)) {
		delete("Could not ignore %s events", eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that event delivered to window A with detail set to NotifyNonlinear. */
		_detail_ = NotifyNonlinear;
		if (winh_climb(A, A, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify events delivered in proper order. */
		increasing = False;
		if (winh_climb(A, C->firstchild->nextsibling, checksequence))
			FAIL;
		else
			CHECK;
/* Verify that detail is set to NotifyNonlinearVirtual on events delivered on */
/* each window between window A and window C, exclusive. */
		_detail_ = NotifyNonlinearVirtual;
		if (winh_climb(A->parent, C->firstchild->nextsibling, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* EnterNotify events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status) {
			report("Incorrect event ordering.");
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(11);
	tpcleanup();
	pfcount(pass, fail);
}

static void t011(){

Display	*display = Dsp;
int	depth = 1;
Winh	*A, *B, *Broot;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion LeaveNotify-11.(C)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("pointer moves from window A to window B and window A and");
	report_assertion("window B are on different screens, then a LeaveNotify event");
	report_assertion("is generated on window A with detail set to NotifyNonlinear.");

	report_strategy("Check to see if multiple screens are supported.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to window A.");
	report_strategy("Select for LeaveNotify and EnterNotify events on windows A and B.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify that the expected events were received.");
	report_strategy("Verify that detail is set to NotifyNonlinear.");
	report_strategy("Verify that all LeaveNotify events are delivered before all");
	report_strategy("EnterNotify events.");

	tpstartup();
/* Check to see if multiple screens are supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set windows A and B. */ 
	A = guardian->firstchild;
	Broot = guardian->nextsibling;
	B = Broot->firstchild;
/* Move pointer to window A. */
	if (warppointer(display, A->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select for xname and EnterNotify events on windows A and B. */
	if (winh_selectinput(display, A, BOTHMASKS)) {
		report("Could not select for events on A");
		return;
	}
	else
		CHECK;
	if (winh_selectinput(display, B, BOTHMASKS)) {
		report("Could not select for events on B");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify that the expected events were received. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = A->window;
	if (winh_plant(A, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event(B, OTHEREVENT, WINH_NOMASK)) {
		report("Could not ignore %s events on B",
			eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that detail is set to NotifyNonlinear. */
		if (A->delivered->event->xcrossing.detail != NotifyNonlinear) {
			report("Got detail %d, expected %d",
				A->delivered->event->xcrossing.detail,
				NotifyNonlinear);
			FAIL;
		}
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* EnterNotify events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status) {
			report("Incorrect event ordering.");
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(10);
	tpcleanup();
	pfcount(pass, fail);
}

static void t012(){

Display	*display;
int	depth = 4;
Winh	*A, *B, *Aroot;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion LeaveNotify-12.(C)");
	report_assertion("If the implementation supports multiple screens: When the");
	report_assertion("pointer moves from window A to window B and window A and");
	report_assertion("window B are on different screens and window A is not a root");
	report_assertion("window, then, after the related LeaveNotify event is");
	report_assertion("generated with detail set to NotifyNonlinear, a LeaveNotify");
	report_assertion("event is generated on each window above A up to and");
	report_assertion("including its root, with detail set to");
	report_assertion("NotifyNonlinearVirtual.");

	report_strategy("Check to see if multiple screens are supported.");
	report_strategy("Create client.");
	report_strategy("Build window hierarchy.");
	report_strategy("Move pointer to window A.");
	report_strategy("Select for LeaveNotify and EnterNotify events on windows A and B.");
	report_strategy("Move pointer from window A to window B.");
	report_strategy("Verify that the expected events were received.");
	report_strategy("Verify that detail is set to NotifyNonlinear for event delivered to A.");
	report_strategy("Verify events delivered on each window above A up to and");
	report_strategy("including its root, with detail set to NotifyNonlinearVirtual.");
	report_strategy("Verify that all LeaveNotify events are delivered before all");
	report_strategy("EnterNotify events.");

	tpstartup();
/* Check to see if multiple screens are supported. */
	if (config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	}
	else
		CHECK;
/* Create client. */
	if ((display = opendisplay()) == (Display *) NULL) {
		delete("Couldn't create client.");
		return;
	}
	else
		CHECK;
/* Build window hierarchy. */
	if (winh(display, depth, WINH_MAP|WINH_BOTH_SCREENS)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
/* Set windows A and B. */ 
	Aroot = guardian;
	A = guardian->firstchild->firstchild->firstchild;
	B = guardian->nextsibling->firstchild;
/* Move pointer to window A. */
	if (warppointer(display, A->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select for xname and EnterNotify events on windows A and B. */
	_event_mask_ = BOTHMASKS;
	_display_ = display;
	if (winh_climb(A, Aroot, selectinput)) {
		report("Could not select for events");
		return;
	}
	else
		CHECK;
	if (winh_selectinput(display, B, BOTHMASKS)) {
		report("Could not select for events on B");
		return;
	}
	else
		CHECK;
/* Move pointer from window A to window B. */
	XSync(display, True);
	XWarpPointer(display, None, B->window, 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify that the expected events were received. */
	good.type = EVENT;
	good.xany.display = display;
	if (winh_climb(A, Aroot, plant)) {
		report("Could not plant events");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	if (winh_ignore_event(B, OTHEREVENT, WINH_NOMASK)) {
		report("Could not ignore %s events on B",
			eventname(OTHEREVENT));
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
/* Verify that detail is set to NotifyNonlinear for event delivered to A. */
		if (A->delivered->event->xcrossing.detail != NotifyNonlinear) {
			report("Got detail %d, expected %d on A",
				A->delivered->event->xcrossing.detail,
				NotifyNonlinear);
			FAIL;
		}
		else
			CHECK;
/* Verify events delivered on each window above A up to and */
/* including its root, with detail set to NotifyNonlinearVirtual. */
		increasing = False;
		if (winh_climb(A, Aroot, checksequence))
			FAIL;
		else
			CHECK;
		_detail_ = NotifyNonlinearVirtual;
		if (winh_climb(A->parent, Aroot, checkdetail))
			FAIL;
		else
			CHECK;
/* Verify that all xname events are delivered before all */
/* EnterNotify events. */
		status = winh_ordercheck(EVENT, OTHEREVENT);
		if (status == -1)
			return;
		else if (status) {
			report("Incorrect event ordering.");
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(13);

	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

Window		w;
Window		w2;
XEvent		ev;
int		gr;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion LeaveNotify-13.(C)");
	report_assertion("If multiple screens are supported: When a LeaveNotify event");
	report_assertion("is delivered and the event and root windows are not on the");
	report_assertion("same screen, then same_screen is set to False.");

	report_strategy("If multiple screens are supported:");
	report_strategy("  Create a window on the default screen.");
	report_strategy("  Create a window on the alternate screen.");
	report_strategy("  Warp the pointer into the first window.");
	report_strategy("  Grab the pointer for the first window.");
	report_strategy("  Warp the pointer to the alternate window.");
	report_strategy("  Verify that an LeaveNotify event was generated relative to the grab window.");
	report_strategy("  Verify that the same_screen component of the event was False.");

	tpstartup();
	/* If multiple screens are supported: */
	if(config.alt_screen == -1) {
		unsupported("Multiple screens not supported.");
		return;
	} else
		CHECK;

			/* Create a window on the default screen. */
        w = defwin(Dsp);
	
			/* Create a window on the alternate screen. */
	w2 = defdraw(Dsp, VI_ALT_WIN);

			/* Warp the pointer into the first window. */
	warppointer(Dsp, w, 2,3);

			/* Grab the pointer for the first window. */
	if((gr=XGrabPointer(Dsp, w, False, EVENTMASK, GrabModeAsync, GrabModeAsync, None, None, CurrentTime)) != GrabSuccess) {
		delete("XGrabPointer() returned %s instead of GrabSuccess.", grabreplyname(gr));
		return;
	} else
		CHECK;

			/* Warp the pointer to the alternate window. */
	XSync(Dsp, True);
	warppointer(Dsp, w2, 1,1);
	XSync(Dsp, False);

			/* Verify that an xname event was generated relative to the grab window. */
	if (XCheckWindowEvent(Dsp, w, EVENTMASK, &ev) == False) {
		report("Expected %s event was not received.", eventname(EVENT));
		FAIL;
	} else {
		CHECK;

			/* Verify that the same_screen component of the event was False. */
		if(ev.xcrossing.same_screen != False) {
			report("The same_screen component of the %s event was not set to False.", eventname(EVENT));
			FAIL;
		} else 
			CHECK;
	}
	
	XUngrabPointer(Dsp, CurrentTime);
	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

Display	*display = Dsp;
Winh	*eventw;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion LeaveNotify-14.(A)");
	report_assertion("When a LeaveNotify event is delivered and the event window");
	report_assertion("is the focus window, then focus is set to True.");

	report_strategy("Build window hierarchy.");
	report_strategy("Set input focus to eventw.");
	report_strategy("Move pointer to window.");
	report_strategy("Select LeaveNotify events on the eventw.");
	report_strategy("Call XWarpPointer to move the pointer to outside of window.");
	report_strategy("Verify event was delivered with focus set to True.");
	report_strategy("Move pointer back to window.");
	report_strategy("Set input focus to known window.");
	report_strategy("Call XWarpPointer to move the pointer to eventw.");
	report_strategy("Verify event was delivered with focus set to False.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, 1, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	eventw = guardian->firstchild;
/* Set input focus to eventw. */
	XSetInputFocus(display, eventw->window, RevertToPointerRoot, CurrentTime);
/* Move pointer to window. */
	if (warppointer(display, eventw->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select xname events on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
/* Call XWarpPointer to move the pointer to outside of window. */
	XSync(display, True);
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify event was delivered with focus set to True. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = eventw->window;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not initialize for event delivery");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		if (eventw->delivered->event->xcrossing.focus != True) {
			report("Focus set to %d, expected %d",
				eventw->delivered->event->xcrossing.focus,True);
			FAIL;
		}
		else
			CHECK;
	}
/* Move pointer back to window. */
	XWarpPointer(display, None, eventw->window, 0, 0, 0, 0, 0, 0);
/* Set input focus to known window. */
	XSetInputFocus(display, eventw->nextsibling->window, RevertToPointerRoot, CurrentTime);
/* Call XWarpPointer to move the pointer to eventw. */
	XSync(display, True);
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify event was delivered with focus set to False. */
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not initialize for event delivery");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		if (eventw->delivered->event->xcrossing.focus != False) {
			report("Focus set to %d, expected %d",
				eventw->delivered->event->xcrossing.focus, False);
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(9);
	tpcleanup();
	pfcount(pass, fail);
}

static void t015(){

Display	*display = Dsp;
Winh	*eventw, *focusw;
int	status;
int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion LeaveNotify-15.(A)");
	report_assertion("When a LeaveNotify event is delivered and the event window");
	report_assertion("is an inferior of the focus window, then focus is set to");
	report_assertion("True.");

	report_strategy("Build window hierarchy.");
	report_strategy("Set input focus to ancestor of window eventw.");
	report_strategy("Move pointer to event window.");
	report_strategy("Select LeaveNotify events on the eventw.");
	report_strategy("Call XWarpPointer to move the pointer outside event window.");
	report_strategy("Verify event was delivered with focus set to True.");

	tpstartup();
/* Build window hierarchy. */
	if (winh(display, 2, WINH_MAP)) {
		report("Could not build window hierarchy");
		return;
	}
	else
		CHECK;
	focusw = guardian->firstchild;
	eventw = guardian->firstchild->firstchild;
/* Set input focus to ancestor of window eventw. */
	XSetInputFocus(display, focusw->window, RevertToPointerRoot, CurrentTime);
/* Move pointer to event window. */
	if (warppointer(display, eventw->window, 0, 0) == (PointerPlace *) NULL)
		return;
	else
		CHECK;
/* Select xname events on the eventw. */
	if (winh_selectinput(display, eventw, MASK))
		return;
	else
		CHECK;
/* Call XWarpPointer to move the pointer outside event window. */
	XSync(display, True);
	XWarpPointer(display, None, DRW(display), 0, 0, 0, 0, 0, 0);
	XSync(display, False);
/* Verify event was delivered with focus set to True. */
	good.type = EVENT;
	good.xany.display = display;
	good.xany.window = eventw->window;
	if (winh_plant(eventw, &good, NoEventMask, WINH_NOMASK)) {
		report("Could not initialize for event delivery");
		return;
	}
	else
		CHECK;
	if (winh_harvest(display, (Winh *) NULL)) {
		report("Could not harvest events");
		return;
	}
	else
		CHECK;
	status = winh_weed((Winh *) NULL, -1, WINH_WEED_IDENTITY);
	if (status < 0)
		return;
	else if (status > 0) {
		report("Event delivery was not as expected");
		FAIL;
	}
	else {
		if (eventw->delivered->event->xcrossing.focus != True) {
			report("Focus set to %d, expected %d",
				eventw->delivered->event->xcrossing.focus, True);
			FAIL;
		}
		else
			CHECK;
	}
	CHECKPASS(6);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
