/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XUngrabPointer(display, thetime)
 *   Display	*display;
 *   Time	thetime;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XUngrabPointer	1
char    *TestName = "XUngrabPointer";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XUngrabPointer function
 */
static Display	*display;
static Time	thetime;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	thetime = CurrentTime;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XEvent	ev;
Window	win;
unsigned int 	mask = PointerMotionMask;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XUngrabPointer-1.(A)");
	report_assertion("When the client has actively grabbed the pointer with a");
	report_assertion("call to XGrabPointer, XGrabButton or from a normal button");
	report_assertion("press, then a call to XUngrabPointer releases the pointer");
	report_assertion("and any queued events.");

	report_strategy("Create a grab window.");
	report_strategy("Grab pointer with pointer_mode GrabModeSync.");
	report_strategy("Warp pointer within the grab window.");
	report_strategy("Verify that no pointer events are received.");
	report_strategy("Call XUngrabPointer to release pointer.");
	report_strategy("Verify that pointer events are now received.");

	tpstartup();
	setargs();
	win = defwin(display);
	XSelectInput(display, win, PointerMotionMask);
	warppointer(display, win, 0, 0);

	XGrabPointer(display, win, False, mask, GrabModeSync, GrabModeAsync,
		None, None, CurrentTime);

	warppointer(display, win, 1, 1);
	if (XCheckMaskEvent(display, (unsigned long)mask, &ev)) {
		delete("Pointer event was received while frozen");
		return;
	} else
		CHECK;

	startcall(display);
	if (isdeleted())
		return;
	XUngrabPointer(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (XCheckMaskEvent(display, (unsigned long)mask, &ev) && ev.type == MotionNotify)
		CHECK;
	else {
		report("Pointer event was not saved while pointer was frozen");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Window	win;
Window	grabwin;
Display	*client2;
XEvent	ev;
unsigned int 	mask;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XUngrabPointer-2.(A)");
	report_assertion("When the specified time is earlier than the");
	report_assertion("last-pointer-grab time or is later than the current X server");
	report_assertion("time, then a call to XUngrabPointer does not release the");
	report_assertion("pointer grab.");

	report_strategy("Create client2.");
	report_strategy("Create window 'win'.");
	report_strategy("Enable events for client2 on win.");
	report_strategy("Create window for use as the grab window.");
	report_strategy("Grab pointer with a given time.");
	report_strategy("Call XUngrabPointer with earlier time.");
	report_strategy("Warp pointer within win.");
	report_strategy("Verify that no event is received for client2.");
	report_strategy("");
	report_strategy("Get current server time.");
	report_strategy("Call XUngrabPointer with a later time than the current server time.");
	report_strategy("Warp pointer within win.");
	report_strategy("Verify that no event is received for client2.");

	tpstartup();
	setargs();
	mask = PointerMotionMask;

	client2 = opendisplay();

	win = defwin(display);
	warppointer(display, win, 0, 0);
	XSelectInput(client2, win, (unsigned long)mask);

	grabwin = defwin(display);

	thetime = gettime(display);
	XGrabPointer(display, grabwin, False, mask, GrabModeSync, GrabModeAsync,
		None, None, thetime);

	XSync(client2, True);
	if (isdeleted())
		return;

	thetime -= 100;
	startcall(display);
	if (isdeleted())
		return;
	XUngrabPointer(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, win, 8, 8);
	if (XCheckMaskEvent(client2, (unsigned long)mask, &ev)) {
		report("Grab was released when time was earlier than last-pointer-grab time");
		FAIL;
	} else
		CHECK;

	XSync(client2, True);	/* Flush any remaining events */

	/*
	 * Get current time again and add several minutes to get a time in the
	 * future.
	 */
	thetime = gettime(display);
	thetime += ((config.speedfactor+1) * 1000000);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabPointer(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	warppointer(display, win, 12, 1);
	if (XCheckMaskEvent(client2, (unsigned long)mask, &ev)) {
		report("Grab was released when time was earlier than last-pointer-grab time");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	grabwin;
Window	win;
XEvent	ev;
XCrossingEvent	*cp;
XEnterWindowEvent	entergood;
XLeaveWindowEvent	leavegood;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XUngrabPointer-3.(A)");
	report_assertion("A call to XUngrabPointer generates EnterNotify and");
	report_assertion("LeaveNotify events.");

	report_strategy("Create the grab window.");
	report_strategy("Create spare window 'win'.");
	report_strategy("Warp pointer to win.");
	report_strategy("Grab pointer with XGrabPointer.");
	report_strategy("Enable events on win and grab windows.");
	report_strategy("Call XUngrabPointer to release grab.");
	report_strategy("Verify that a leave event is generated on the grab window.");
	report_strategy("Verify that an enter event is generated on win.");

	tpstartup();
	setargs();
	grabwin = defwin(display);
	win = defwin(display);

	warppointer(display, win, 0, 0);

	XGrabPointer(display, grabwin, False, (unsigned int)PointerMotionMask,
		GrabModeSync, GrabModeAsync, None, None, CurrentTime);

	XSelectInput(display, win, EnterWindowMask|LeaveWindowMask);
	XSelectInput(display, grabwin, EnterWindowMask|LeaveWindowMask);

	startcall(display);
	if (isdeleted())
		return;
	XUngrabPointer(display, thetime);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	defsetevent(entergood, display, EnterNotify);
	entergood.root = DRW(display);
	entergood.subwindow = None;
	entergood.time = 0;
	entergood.mode = NotifyNormal;
	entergood.detail = NotifyNonlinear;
	entergood.same_screen = True;
	entergood.focus = False;
	entergood.state = 0;

	defsetevent(leavegood, display, LeaveNotify);
	leavegood.root = DRW(display);
	leavegood.subwindow = None;
	leavegood.time = 0;
	leavegood.mode = NotifyNormal;
	leavegood.detail = NotifyNonlinear;
	leavegood.same_screen = True;
	leavegood.focus = False;
	leavegood.state = 0;

	/*
	 * There is an Ungrab mode leave from the grab window followed by
	 * an enter to the original window.
	 */
	leavegood.window = grabwin;
	leavegood.mode = NotifyUngrab;
	entergood.window = win;
	entergood.mode = NotifyUngrab;

	if (getevent(display, &ev) == 0 || ev.type != LeaveNotify) {
		report("No ungrab-mode leave event from the grab window");
		FAIL;
	} else
		CHECK;

	cp = (XCrossingEvent*)&ev;
	/* Set the fields that we can't conveniently check */
	leavegood.time = cp->time;
	leavegood.x = cp->x;
	leavegood.y = cp->y;
	leavegood.x_root = cp->x_root;
	leavegood.y_root = cp->y_root;
	leavegood.focus = cp->focus;
	if (checkevent((XEvent*)&leavegood, &ev))
		FAIL;
	else
		CHECK;

	if (getevent(display, &ev) == 0 || ev.type != EnterNotify) {
		report("No ungrab-mode enter notify event to window pointer is in");
		FAIL;
	} else
		CHECK;

	/* The cursor was at 0,0 */
	entergood.x = 0;
	entergood.y = 0;

	cp = (XCrossingEvent*)&ev;
	/* Set the fields that we can't conveniently check */
	entergood.time = cp->time;
	entergood.x_root = cp->x_root;
	entergood.y_root = cp->y_root;
	entergood.focus = cp->focus;
	if (checkevent((XEvent*)&entergood, &ev))
		FAIL;
	else
		CHECK;
	
	CHECKPASS(4);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
