/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* 
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmPutLineResource(database, line)
 *   XrmDatabase *database;
 *   char *line;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XrmPutLineResource	1
char    *TestName = "XrmPutLineResource";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XrmPutLineResource function
 */
static XrmDatabase *database;
static char *line;


static XrmDatabase xplr_database;

#define XPLR_T1_COUNT 23

static char *t1_lines[XPLR_T1_COUNT][5] = {
/* Capital 'T' is transformed to TAB in the prefix and conjunct. */
/* prefix, resource, conjunt, value, specifier, newvalue */
{"",	"a.a",	":",	"one",	"a.a"	}, /* Normal Line */

{" ",	"a.b",	":",	"two",	"a.b"	}, /* pre-resource space */
{"T",	"a.c",	":",	"three","a.c"	}, /* pre-resource tab*/
{" T ",	"a.d",	":",	"four",	"a.d"	}, /* pre-resource ws */

{"",	"a.e",	" :",	"five",	"a.e"	}, /* post-resource space */
{"",	"a.f",	"T:",	"six",	"a.f"	}, /* post-resource tab */
{"",	"a.g",	" T :",	"seven","a.g"	}, /* post-resource ws */

{"",	"a.h",	": ",	"eight","a.h"	}, /* pre-value space */
{"",	"a.i",	":T",	"nine",	"a.i"	}, /* pre-value tab */
{"",	"a.j",	": T ",	"ten",	"a.j"	}, /* pre-value ws */

{"  ",	"a.k",	"   :  ","eleven","a.k"	}, /* multiple space */
{"TT",	"a.l",	"TT:TTTT","twelve","a.l"}, /* multiple tab */
{"T  T","a.m",	" T:T   ","thirteen","a.m"}, /* multiple ws */

{"",	".a.n",	":",	"fourteen","a.n"}, /* pre-resource binding . */
{"",	"*a.o",	":",	"fifteen", "b.a.o"}, /* pre-resource binding * */

{"",	"a*p",	":",	"sixteen", "a.z.p"}, /* inclusive binding * */
{"",	".a*q",	":",	"seventeen","a.z.q"}, /* inclusive binding * */

{"",	"*a*r",	":",	"eighteen","b.a.c.r"}, /* inclusive binding * */

{"",	"b",	":",	"nineteen","b"	}, /* lone component */
{"",	".c",	":",	"twenty", "c"	}, /* lone component */
{"",	"*z",	":",	"twenty one","b.z"	}, /* lone component */

{"",	"d",	":",	"Aa9! @#$%^&*()_+~", "d"}, /* complex value */

{"T ",	"a-z.r_9A-*a-8B","T: ","A* bZ_% !?", "a-z.r_9A-.z.a-8B"} };/* complex entry */



static XrmDatabase
xrm_create_database(data)
char *data;
{
	/* Create a new database for testing with */
	return(XrmGetStringDatabase(data));
}

static void
xrm_fill_value(value, data)
XrmValue *value;
char *data;
{
	value->addr = (caddr_t)data;
	value->size = (unsigned int)(strlen(data)+1);
}

static int
xrm_check_entry(dbase, fullspec, fullclass, type, val)
XrmDatabase dbase;
char *fullspec;
char *fullclass;
char *type;
char *val;
{
	int ret_val;
	char	*type_ret;
	XrmValue	value_ret;

	ret_val=0;
	type_ret=(char *)NULL;
	value_ret.size=0;
	value_ret.addr=(caddr_t)NULL;

	if(XrmGetResource(dbase, fullspec, fullclass, &type_ret, &value_ret)
		==False) {
		report("XrmGetResource failed to find database entry");
		report("Specifier was: %s", fullspec);
		ret_val++;
	} else {
		if (type_ret==NULL || strcmp(type_ret, type)) {
			report("XrmGetResource returned unexpected type information.");
			report("Specifier was: %s", fullspec);
			report("Expected type: '%s'", type);
			report("Returned type: '%s'",
				(type_ret==NULL)?"<NULL POINTER>":type_ret);
			ret_val++;
		}

		if (( value_ret.addr==(caddr_t)NULL)
			|| (strncmp((char *)value_ret.addr, val, strlen(val)))) {
			report("XrmGetResource returned unexpected value information.");
			report("Specifier was: %s", fullspec);
			report("Expected value: '%s'", val);
			if(value_ret.addr == (caddr_t)NULL) {
				report("Returned value: <NULL POINTER>");
			} else {
				report("Returned value: '%.*s' (%u bytes)",
					value_ret.size, (char *)value_ret.addr, value_ret.size);
			}
			ret_val++;
		}
	}

	return(ret_val);
}

static int
xrm_tabulate(from, into)
char *from, *into;
{
	int i,j;

	j = strlen(from);
	for(i=0; i<j; i++) {
		if(from[i]=='T') {
			into[i]='\t';
		} else {
			into[i]=from[i];
		}
	}
	return(j);
}

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	database = &xplr_database;
	line = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

/* Including from file rescommon.mc */
/* End of included file rescommon.mc */

static void t001(){

int i,j,k;
char tbuf[256], *tptr;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XrmPutLineResource-1.(A)");
	report_assertion("When line is in ResourceLine format, then a call to");
	report_assertion("XrmPutLineResource adds a resource name and value pair from");
	report_assertion("the specified line to the specified database.");

	report_strategy("Create empty database for testing.");
	report_strategy("Call XrmPutLineResource to add test lines to the database.");
	report_strategy("Verify the test lines were added to the database as expected.");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

/* Call xname to add test lines to the database. */
	for(i=0; i<XPLR_T1_COUNT; i++) {

		tptr=tbuf;
		for(j=0; j<4; j++) {
			tptr += xrm_tabulate(t1_lines[i][j], tptr);
			CHECK;
		}
		*tptr = '\0';
		trace("line: %s", tbuf);

		line=tbuf;
		startcall(Dsp);
		if (isdeleted())
			return;
		XrmPutLineResource(database, line);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}
		
/* Verify the test lines were added to the database as expected. */
	for(i=0; i<XPLR_T1_COUNT; i++) {
		tptr=tbuf;
		k = xrm_tabulate(t1_lines[i][3], tptr);
		tbuf[k] = '\0';
		if(xrm_check_entry(xplr_database,
			t1_lines[i][4], t1_lines[i][4],
			"String", tbuf)) {
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(1 + 4*XPLR_T1_COUNT + XPLR_T1_COUNT);

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_one");
#endif

	XrmDestroyDatabase(xplr_database);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int i,j,k;
char tbuf[256], *tptr;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XrmPutLineResource-2.(A)");
	report_assertion("When the database contains an entry for the resource name");
	report_assertion("specified by line, then a call to XrmPutLineResource");
	report_assertion("replaces the resource value in the database with the");
	report_assertion("resource value associated with line.");

	report_strategy("Create empty database for testing.");
	report_strategy("Call XrmPutLineResource to add test lines to the database.");
	report_strategy("Call XrmPutLineResource to replace the database entries.");
	report_strategy("Verify the database entries were replaced as expected.");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

/* Call xname to add test lines to the database. */
	for(i=0; i<XPLR_T1_COUNT; i++) {
		tptr=tbuf;
		for(j=0; j<3; j++) {
			tptr += xrm_tabulate(t1_lines[i][j], tptr);
			CHECK;
		}
		tptr += xrm_tabulate("testvalue", tptr);
		*tptr = '\0';

		line=tbuf;
		startcall(Dsp);
		if (isdeleted())
			return;
		XrmPutLineResource(database, line);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}

/* Call xname to replace the database entries. */
	for(i=0; i<XPLR_T1_COUNT; i++) {
		tptr=tbuf;
		for(j=0; j<4; j++) {
			tptr += xrm_tabulate(t1_lines[i][j], tptr);
			CHECK;
		}
		*tptr = '\0';

		line=tbuf;
		startcall(Dsp);
		if (isdeleted())
			return;
		XrmPutLineResource(database, line);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}

/* Verify the database entries were replaced as expected. */
	for(i=0; i<XPLR_T1_COUNT; i++) {
		tptr=tbuf;
		k = xrm_tabulate(t1_lines[i][3], tptr);
		tbuf[k] = '\0';
		if(xrm_check_entry(xplr_database,
			t1_lines[i][4], t1_lines[i][4],
			"String", tbuf)) {
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS( 1 + 3*XPLR_T1_COUNT + 4*XPLR_T1_COUNT + XPLR_T1_COUNT );

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_two");
#endif

	XrmDestroyDatabase(xplr_database);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XrmPutLineResource-3.(A)");
	report_assertion("When line is in ResourceLine format and database is NULL,");
	report_assertion("then a call to XrmPutLineResource creates a new database,");
	report_assertion("adds a resource name and value pair from the specified line");
	report_assertion("to the database, and returns a pointer to the database in");
	report_assertion("database.");

	report_strategy("Call XrmPutLineResource to add data to a NULL database.");
	report_strategy("Verify that the database was created, and the data was added as expected.");

	tpstartup();
	setargs();
/* Call xname to add data to a NULL database. */
	xplr_database = (XrmDatabase)NULL;
	line="one.two.three:testing";
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
/* Verify that the database was created, and the data was added as expected. */
	if (xplr_database== (XrmDatabase)NULL) {
		FAIL;
		report("%s did not create a new database when called with",
			TestName);
		report("*database=(XrmDatabase)NULL");
	} else {
		CHECK;
		if (xrm_check_entry(xplr_database,
			"one.two.three", "ONE.TWO.THREE",
			"String", "testing")) {
			FAIL;
			report("%s did not add to the database as expected.",
				TestName);
		} else
			CHECK;
	}
	
	CHECKPASS(2);

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_three");
#endif

	XrmDestroyDatabase(xplr_database);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

char tbuf[256];
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XrmPutLineResource-4.(A)");
	report_assertion("On a call to XrmPutLineResource, any white space before or");
	report_assertion("after the name or colon in the line argument is ignored.");

	report_strategy("Create empty database for testing.");
	report_strategy("Call XrmPutLineResource to add an entry with white space around the name and colon.");
	report_strategy("Verify that the white space had no effect upon the entry.");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

/* Call xname to add an entry with white space around the name and colon. */
	tbuf[xrm_tabulate("T a.b.c T:  Ttest", tbuf)] = '\0';
	line=tbuf;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the white space had no effect upon the entry. */
	if (xrm_check_entry(xplr_database,
		"a.b.c", "a.b.c",
		"String", "test")) {
		FAIL;
		report("%s did not add to the database as expected.",
			TestName);
		report("White space effects database entries");
	} else
		CHECK;

	CHECKPASS(2);

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_four");
#endif

	XrmDestroyDatabase(xplr_database);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

char tbuf[256], *tptr;
char *type_ret;
XrmValue value_ret;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XrmPutLineResource-5.(A)");
	report_assertion("On a call to XrmPutLineResource, the processing of line is");
	report_assertion("terminated at a new-line or an ASCII nul character.");

	report_strategy("Create empty database for testing.");
	report_strategy("Create a test string containing a new-line character.");
	report_strategy("Call XrmPutLineResource to add the data to the database.");
	report_strategy("Verify that only a single entry was added to the database.");
	report_strategy("Create a test string containing a nul character.");
	report_strategy("Call XrmPutLineResource to add the data to the database.");
	report_strategy("Verify that only a single entry was added to the database.");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

/* Create a test string containing a new-line character. */
	tptr = tbuf;
	tptr += xrm_tabulate("one:test", tbuf);
	*tptr++ = '\n';
	tptr += xrm_tabulate("two:another test", tptr);
	*tptr='\0';

/* Call xname to add the data to the database. */
	line = tbuf;
	trace("test string: '%s'", line);
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that only a single entry was added to the database. */
	if (xrm_check_entry(xplr_database,
		"one", "one", "String", "test")) {
		FAIL;
	} else
		CHECK;

	if (XrmGetResource(xplr_database, "two", "two",
		&type_ret, &value_ret)) {
		FAIL;
		report("Unexpected entry indicates that a newline");
		report("does not terminate line processing for %s",
			TestName);
		trace("'two:%s' was unexpectedly present in the database.",
			(value_ret.addr!=(char *)NULL?
			(char *)value_ret.addr:"<NULL_POINTER"));
	} else
		CHECK;

/* Create a test string containing a nul character. */
	tptr = tbuf;
	tptr += xrm_tabulate("three:test", tbuf);
	*tptr++ = '\0';
	tptr += xrm_tabulate("four:another test", tptr);
	*tptr='\0';

/* Call xname to add the data to the database. */
	line = tbuf;
	trace("test string: '%s'", line);
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that only a single entry was added to the database. */
	if (xrm_check_entry(xplr_database,
		"three", "three", "String", "test")) {
		FAIL;
	} else
		CHECK;

	if (XrmGetResource(xplr_database, "four", "four",
		&type_ret, &value_ret)) {
		FAIL;
		report("Unexpected entry indicates that an ASCII nul ");
		report("does not terminate line processing for %s",
			TestName);
	} else
		CHECK;

	CHECKPASS(5);

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_five");
#endif

	XrmDestroyDatabase(xplr_database);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

char tbuf[256];
char tstr[4];
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XrmPutLineResource-6.(A)");
	report_assertion("When the line argument contains \n, then on a call to");
	report_assertion("XrmPutLineResource this is interpreted as the new-line");
	report_assertion("character.");

	report_strategy("Create empty database for testing.");
	report_strategy("Call XrmPutLineResource to add an entry including a \n in the value.");
	report_strategy("Verify that the \n was treated as an embedded newline.");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

/* Call xname to add an entry including a \n in the value. */
	tbuf[xrm_tabulate("one.two.three:t\\n!", tbuf)] = '\0';
	line=tbuf;
	trace("test string: '%s'", line);
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the \n was treated as an embedded newline. */
	tstr[0]='t';
	tstr[1]='\n';
	tstr[2]='!';
	tstr[3]='\0';
	if (xrm_check_entry(xplr_database,
		"one.two.three", "One.Two.Three",
		"String", tstr)) {
		FAIL;
		report("%s did not add to the database as expected.",
			TestName);
		report("\\n was not treated as an embedded character.");
		report("(whitespace in values represents \\n)");
	} else
		CHECK;

	CHECKPASS(2);

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_six");
#endif

	XrmDestroyDatabase(xplr_database);
	
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

char tbuf[256];
char tstr[4];
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XrmPutLineResource-7.(A)");
	report_assertion("When the line argument contains \nnn where n is a digit");
	report_assertion("from zero to seven, then on a call to XrmPutLineResource");
	report_assertion("this is interpreted as a single byte containing the");
	report_assertion("corresponding octal character.");

	report_strategy("Create empty database for testing.");
	report_strategy("Call XrmPutLineResource to add an entry including a \100 in the value.");
	report_strategy("Verify that the \100 was treated as a character .");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	} else
		CHECK;

/* Call xname to add an entry including a \100 in the value. */
	tbuf[xrm_tabulate("one.two.three:t\\100!", tbuf)] = '\0';
	line=tbuf;
	trace("test string: '%s'", line);
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the \100 was treated as a character . */
	tstr[0]='t';
	tstr[1]=(char)0x40;
	tstr[2]='!';
	tstr[3]='\0';
	if (xrm_check_entry(xplr_database,
		"one.two.three", "One.Two.Three",
		"String", tstr)) {
		FAIL;
		report("%s did not add to the database as expected.",
			TestName);
		report("\\nnn was not treated as an embedded character.");
	} else
		CHECK;

	CHECKPASS(2);

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_seven");
#endif

	XrmDestroyDatabase(xplr_database);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

int i,j;
char tbuf[256], *tptr;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XrmPutLineResource-8.(A)");
	report_assertion("When line is a comment then a call to XrmPutLineResource");
	report_assertion("does not add the line to the specified database.");

	report_strategy("Create empty database for testing.");
	report_strategy("Call XrmPutLineResource to test comments.");
	report_strategy("Verify that comments did not affect the database contents.");

	tpstartup();
	setargs();
/* Create empty database for testing. */
	xplr_database=xrm_create_database("");
	if (xplr_database = (XrmDatabase)NULL) {
		delete("Could not create test database.");
		return;
	}

/* Call xname to add test lines to the database. */
	for(i=0; i<XPLR_T1_COUNT; i++) {

		tptr=tbuf;
		for(j=0; j<4; j++) {
			tptr += xrm_tabulate(t1_lines[i][j], tptr);
			CHECK;
		}
		*tptr = '\0';
		trace("line: %s", tbuf);

		line=tbuf;
		startcall(Dsp);
		if (isdeleted())
			return;
		XrmPutLineResource(database, line);
		endcall(Dsp);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}
	}

/* Call xname to test comments. */
	tbuf[0]= '!';
	tptr=tbuf+1;
	tptr += xrm_tabulate(t1_lines[1][1], tptr);
	tptr += xrm_tabulate(":COMMENTS EFFECT DATABASE", tptr);
	*tptr = '\0';

	line=tbuf;
	startcall(Dsp);
	if (isdeleted())
		return;
	XrmPutLineResource(database, line);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
		
/* Verify that comments did not affect the database contents. */
	if(xrm_check_entry(xplr_database,
		t1_lines[1][4], t1_lines[1][4],
		"String", t1_lines[1][3])) {
		FAIL;
		report("On a call to %s, resources within comments affect",
			TestName);
		report("the resource database.");
	} 

#ifdef TESTING
	XrmPutFileDatabase(xplr_database, "xplr_one");
#endif

	XrmDestroyDatabase(xplr_database);

	tet_result(TET_PASS);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.28591 */
static void t009(){

int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XrmPutLineResource-9.(B)");
	report_assertion("The result of a call to XrmPutLineResource when the");
	report_assertion("resource name in line is not in the Host Portable Character");
	report_assertion("Encoding.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.28591 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = rmstartup;
void	(*tet_cleanup)() = cleanup;
