/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   
 *   XIntersectRegion(sra, srb, dr_return)
 *   Region	sra;
 *   Region	srb;
 *   Region	dr_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XIntersectRegion	1
char    *TestName = "XIntersectRegion";

/*
 * Defines for different argument types
 */


/*
 * Arguments to the XIntersectRegion function
 */
static Region	sra;
static Region	srb;
static Region	dr_return;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	sra = 0;
	srb = 0;
	dr_return = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

static	XPoint	inter1[] = { {25,5}, {15,10}, {10,25}, {20,35}, {30,30}, {35,20}, {30,10} };
static	XPoint	inter2[] = { {25,20}, {37,22}, {40,30}, {35,37}, {30,40}, {25,38}, {18,32}, {20,25} };
Region		R1;
Region		R2;
Region		Ri;
Region		Rt;
Region		Ru;
Region		Rx;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XIntersectRegion-1.(A)");
	report_assertion("A call to XIntersectRegion computes the intersection of the");
	report_assertion("regions sra and srb and replaces the value of dr_return with");
	report_assertion("the result.");

	report_strategy("Create regions R1, R2 and R3 using XCreateRegion.");
	report_strategy("Verify that none of the calls returned NULL.");
	report_strategy("Set R1 to a polygon using XPolygonRegion.");
	report_strategy("Set R2 to a polygon which intersects the first using XPolygonRegion.");
	report_strategy("Obtain the intersection of R1 and R2 into R3 using XIntersectRegion.");
	report_strategy("Verify that the result is not empty using XEmptyRegion.");
	report_strategy("");
	report_strategy("Test that ((R1 ^ R2) | (R1 & R2)) == (R1 | R2):");
	report_strategy("   Obtain union of R1 and R2 into Ru using XUnionRegion.");
	report_strategy("   Obtain exclusive-or of R1 and R2 into Rx using XXorRegion.");
	report_strategy("   Obtain union of Rx and R3 using XUnionRegion.");
	report_strategy("   Verify that result equals Ru using XEqualRegion.");
	report_strategy("");
	report_strategy("Create three regions using XCreateRegion.");
	report_strategy("Set two of the regions to disjoint polygons using XPolygonRegion.");
	report_strategy("Obtain the intersection of the regions using XIntersectRegion.");
	report_strategy("Verify that the returned region was empty using XEmptyRegion.");

	tpstartup();
	setargs();
	R1 = makeregion();
	R2 = makeregion();
	Ri = makeregion();
	Rt = makeregion();
	Ru = makeregion();
	Rx = makeregion();

	if(isdeleted()) return;

	R1 = XPolygonRegion( inter1, NELEM(inter1), WindingRule );
	R2 = XPolygonRegion( inter2, NELEM(inter2), WindingRule );
	XUnionRegion(R1, R2, Ru);

	sra = R1;
	srb = R2;
	dr_return = Ri;	
	startcall(Dsp);
	if (isdeleted())
		return;
	XIntersectRegion(sra, srb, dr_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( XEmptyRegion(Ri) == True ) {
		report("%s() returned the empty region for two intersecting regions.", TestName);
		FAIL;
	} else
		CHECK;

	XXorRegion(R1, R2, Rx);
	XUnionRegion(Rx, Ri, Rt);
	
	if(XEqualRegion(Ru, Rt) != True) {
		report("%s() returned a region not completely contained in a source region.", TestName);
		FAIL;
	} else
		CHECK;

	R1 = makeregion();
	R2 = makeregion();
	Ri = makeregion();

	sra = R1;
	srb = R2;
	dr_return = Ri;	
	startcall(Dsp);
	if (isdeleted())
		return;
	XIntersectRegion(sra, srb, dr_return);
	endcall(Dsp);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if( XEmptyRegion(Ri) != True ) {
		report("%s() returned a non-empty region for two non-intersecting intersecting regions.", TestName);
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
