/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XConnectionNumber(display)
 *   Display	*display;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XConnectionNumber	1
char    *TestName = "XConnectionNumber";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XConnectionNumber function
 */
static Display	*display;


static int 	ValueReturn;

static	Display	*client;
static	int	exit_status = -1;
static	int	path_checker = -1;

static int
errorhandler(display)
Display *display;
{
	/* Handler exits with exit status of exit_status. */
	if(path_checker == 2)
		exit(exit_status);
	else
		exit(exit_status - 1);
}

/*
 * Child exits with exit_status on success.
 * Child exits with exit_status+1 to indicate TET_DELETE.
 * Child exits with exit_status-1 to indicate close failure.
 */
static	void
closer()
{
int	cnn;	

	path_checker = 0;
	XSetIOErrorHandler( errorhandler );
	client = opendisplay();

	if (client == (Display *) NULL) {
		report("Cannot open display.");
		exit(exit_status + 1);
	} else
		path_checker++;

	cnn = XConnectionNumber(client); 

	if (close(cnn)) {
		report("Close failed on ConnectionNumber %d.", cnn);
		exit(exit_status + 1);
	} else
		path_checker++;

	XNoOp(client);
	XFlush(client);
	report("Handler not invoked or did not exit");
	exit(exit_status - 1);
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int	child_exit;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XConnectionNumber-1.(D)");
	report_assertion("If the system is POSIX compliant: A call to");
	report_assertion("XConnectionNumber returns the file descriptor of the display");
	report_assertion("specified by the display argument. Otherwise: A call to");
	report_assertion("XConnectionNumber returns the connection number of the");
	report_assertion("display specified by the display argument.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("If the system is POSIX compliant:");
	report_strategy("  Open a display using XOpenDisplay.");
	report_strategy("  Create a child process.");
	report_strategy("  In Child :");
	report_strategy("    Set IOErrorHandler to an errorhandler function which exits immediately.");
	report_strategy("    Obtain the connection number of the display using XConnectionNumber.");
	report_strategy("    Close the connection using close.");
	report_strategy("    Perform a XNoOp request on the display.");
	report_strategy("    Flush the O/P using using XFlush.");
	report_strategy("  In parent:");
	report_strategy("    Obtain child's exit status.");
	report_strategy("    Verify that the child exited from the error handler.");
	report_strategy("Otherwise:");
	report_strategy("  UNTESTED");

	tpstartup();
	setargs();
	if(config.posix_system == 1) {
		exit_status = 1;
		child_exit = tet_fork(closer, TET_NULLFP, 0, ~0);

		if (child_exit == exit_status+1) {
			delete("Child process experienced unexpected problem.");
			return;
		} else {
			CHECK;

			if (child_exit != exit_status) {
				report("The IOError handler was not invoked (got %d exit status, expected %d).", child_exit, exit_status);
				FAIL;
			} else
				CHECK;
		}
		CHECKPASS(2);
	} else
		untested("The assertion can only be tested on a POSIX compliant system.");
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
