/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XMapWindow(display, w)
 *   Display	*display;
 *   Window	w;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XMapWindow	1
char    *TestName = "XMapWindow";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW w
#define A_DRAWABLE w


/*
 * Arguments to the XMapWindow function
 */
static Display	*display;
static Window	w;



static char	*T1[] = {
	".",
	"A . (10, 10) 70x70 unmap",
	  "A1 A (20, 2) 20x5",
		"A1a A1 (10,1) 5x3",
	  "B A (10, 10) 50x50 unmap",
		"C B (10, 10) 30x30 unmap",
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	w = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	w = ErrdefWindow;
}

static void t001(){

Window	base;
XWindowAttributes	atts;
struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XMapWindow-1.(A)");
	report_assertion("A call to XMapWindow maps the specified window.");

	report_strategy("Create unmapped window.");
	report_strategy("Set window background to W_FG.");
	report_strategy("Map window.");
	report_strategy("Verify map state is IsViewable.");
	report_strategy("Verify that window shows on screen.");

	tpstartup();
	setargs();
	base = defwin(display);

	setarea(&area, 10, 10, 30, 30);
	w = creunmapchild(display, base, &area);
	XSetWindowBackground(display, w, W_FG);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsViewable) {
		report("map state after map was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsViewable));
		FAIL;
	} else
		CHECK;

	if (checkarea(display, base, &area, W_FG, W_BG, CHECK_ALL))
		CHECK;
	else {
		report("Mapped window was displayed incorrectly or was not seen on screen");
		FAIL;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){


 	report_purpose(2);

	report_assertion("Assertion XMapWindow-2.(-)");
	report_assertion("When a call to XMapWindow is made on a window that has no");
	report_assertion("unmapped ancestors, then the window becomes viewable.");
	report_assertion("The assertion is descriptive or is tested elsewhere.");
	tet_result(TET_NOTINUSE);
}

static void t003(){

Window	base;
struct	buildtree	*btp;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XMapWindow-3.(A)");
	report_assertion("When a call to XMapWindow is made on a window that has an");
	report_assertion("unmapped ancestor, then the window does not become viewable.");

	report_strategy("Create stack of unmapped windows.");
	report_strategy("Map one of these window that has an unmapped ancestor.");
	report_strategy("Verify map state is IsUnviewable.");
	report_strategy("Verify that nothing becomes visible.");

	tpstartup();
	setargs();
	base = defwin(display);
	btp = buildtree(display, base, T1, NELEM(T1));

	/* We shall map window B which has A as an unmapped ancestor */
	w = btntow(btp, "B");

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsUnviewable) {
		report("map state after map was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsUnviewable));
		FAIL;
	} else
		CHECK;

	if (checkarea(display, base, (struct area *)0, W_BG, W_BG, CHECK_ALL))
		CHECK;
	else {
		report("Somthing became visible after mapping window with unmapped ancestors");
		FAIL;
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Window	base;
Window	ch1;
Window	ch2;
struct	buildtree	*btp;
XWindowAttributes	atts;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XMapWindow-4.(A)");
	report_assertion("When a call to XMapWindow is made on a window that is the");
	report_assertion("only unmapped ancestor of an inferior window that has");
	report_assertion("previously been mapped, then that inferior window becomes");
	report_assertion("viewable.");

	report_strategy("Create stack of windows with mapped windows as inferiors of an unmapped window.");
	report_strategy("Check that map-state of inferiors is IsUnviewable.");
	report_strategy("Map the ancestor window.");
	report_strategy("Verify that map-state of inferiors is IsViewable.");
	report_strategy("Verify that windows become visible on the screen.");

	tpstartup();
	setargs();
	base = defwin(display);
	btp = buildtree(display, base, T1, NELEM(T1));

	ch1 = btntow(btp, "A1");
	ch2 = btntow(btp, "A1a");

	XGetWindowAttributes(display, ch1, &atts);
	if (atts.map_state != IsUnviewable) {
		report("map state for A1 was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsUnviewable));
		FAIL;
	} else
		CHECK;

	XGetWindowAttributes(display, ch2, &atts);
	if (atts.map_state != IsUnviewable) {
		report("map state for A1a was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsUnviewable));
		FAIL;
	} else
		CHECK;

	w = btntow(btp, "A");

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XGetWindowAttributes(display, ch1, &atts);
	if (atts.map_state != IsViewable) {
		report("map state for A1 was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsViewable));
		FAIL;
	} else
		CHECK;

	XGetWindowAttributes(display, ch2, &atts);
	if (atts.map_state != IsViewable) {
		report("map state for A1a was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsViewable));
		FAIL;
	} else
		CHECK;

	PIXCHECK(display, base);

	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	base;
struct	area	area;
XWindowAttributes	atts;
XImage	*imp;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XMapWindow-5.(A)");
	report_assertion("When the window is already mapped, then a call to");
	report_assertion("XMapWindow has no effect.");

	report_strategy("Create window.");
	report_strategy("Map window.");
	report_strategy("Enable events.");
	report_strategy("Attempt to map window again.");
	report_strategy("Verify that no difference occurred on screen.");
	report_strategy("Verify that map-state is still IsViewable.");
	report_strategy("Verify that no events are generated.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 10, 10, 40, 40);
	w = creunmapchild(display, base, &area);
	XSetWindowBackground(display, w, W_FG);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	imp = savimage(display, w);

	XSelectInput(display, w, ALLEVENTS);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, w, NoEventMask);

	if (compsavimage(display, w, imp))
		CHECK;
	else {
		report("Difference occurred on screen after re-mapping window");
		FAIL;
	}

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsViewable) {
		report("map state after map was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsViewable));
		FAIL;
	} else
		CHECK;

	if (XPending(display) != 0) {
		report("Re-mapping window produced event");
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

Display	*client2;
Window	base;
XSetWindowAttributes	setatts;
XWindowAttributes	atts;
XMapRequestEvent	good;
XEvent	ev;
struct	area	area;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XMapWindow-6.(A)");
	report_assertion("When the override_redirect attribute of the window is False");
	report_assertion("and some other client has selected SubstructureRedirectMask");
	report_assertion("on the parent window, then a MapRequest event is generated,");
	report_assertion("and the call to XMapWindow does not map the window.");

	report_strategy("Create base window.");
	report_strategy("Create unmapped window on base window.");
	report_strategy("Set override-redirect attribute to False.");
	report_strategy("Create second client.");
	report_strategy("Select SubstructureRedirect for second client on base window.");
	report_strategy("Map window.");
	report_strategy("Verify that the MapRequest event is generated on second client.");
	report_strategy("Verify that map-state is still IsUnmapped.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 20, 20, 40, 40);
	w = creunmapchild(display, base, &area);
	setatts.override_redirect = False;
	XChangeWindowAttributes(display, w, CWOverrideRedirect, &setatts);
	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, base, SubstructureRedirectMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	good.type = MapRequest;
	good.serial = 0;
	good.send_event = False;
	good.display = client2;
	good.parent = base;
	good.window = w;

	n = getevent(client2, &ev);
	if (n != 1) {
		report("Expecting one event on second client, received %d", n);
		FAIL;
	} else if (checkevent((XEvent *)&good, &ev))
		FAIL;
	else
		CHECK;

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsUnmapped) {
		report("map state after map was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsUnmapped));
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t007(){

Display	*client2;
Window	base;
XSetWindowAttributes	setatts;
XWindowAttributes	atts;
XMapEvent	good;
XEvent	ev;
struct	area	area;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XMapWindow-7.(A)");
	report_assertion("When the override-redirect attribute of the window is True,");
	report_assertion("then on a call to XMapWindow the window is mapped and a");
	report_assertion("MapNotify event is generated.");

	report_strategy("Create base window.");
	report_strategy("Create unmapped window on base window.");
	report_strategy("Set override-redirect attribute to True.");
	report_strategy("Select StructureNotify events on window.");
	report_strategy("Create second client.");
	report_strategy("Select SubstructureRedirect and SubstructureNotify for second client on base window.");
	report_strategy("Map window.");
	report_strategy("Verify that a MapNotify event is generated on parent.");
	report_strategy("Verify that a MapNotify event is generated on window.");
	report_strategy("Verify that the map_state of the window is IsViewable.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 20, 20, 40, 40);
	w = creunmapchild(display, base, &area);
	setatts.override_redirect = True;
	XChangeWindowAttributes(display, w, CWOverrideRedirect, &setatts);
	/*
	 * Would normally select ALLEVENTS to test for spurious events.
	 * This cannot be done here, since we would possibly get valid 
	 * EnterNotify's etc.
	 */
	XSelectInput(display, w, StructureNotifyMask);
	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, base,SubstructureRedirectMask|SubstructureNotifyMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	/*
	 * Check for Map event on parent.
	 */
	good.type = MapNotify;
	good.serial = 0;
	good.send_event = False;
	good.display = client2;
	good.event = base;
	good.window = w;
	good.override_redirect = True;

	n = getevent(client2, &ev);
	if (n != 1) {
		report("Expecting one event on second client, received %d", n);
		FAIL;
	} else if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;

	/*
	 * Now check for map notify on the window itself.
	 */
	good.display = display;
	good.event = w;

	n = getevent(display, &ev);
	if (n != 1) {
		report("Expecting one Map notify event, received %d events", n);
		FAIL;
	} else if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsViewable) {
		report("map state after map was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsViewable));
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t008(){

Display	*client2;
Window	base;
XSetWindowAttributes	setatts;
XWindowAttributes	atts;
XMapEvent	good;
XEvent	ev;
struct	area	area;
int 	n;
int 	pass = 0, fail = 0;

 	report_purpose(8);

	report_assertion("Assertion XMapWindow-8.(A)");
	report_assertion("When no other client has selected SubstructureRedirectMask");
	report_assertion("on the parent window, then on a call to XMapWindow the");
	report_assertion("window is mapped and a MapNotify event is generated.");

	report_strategy("Create base window.");
	report_strategy("Create unmapped window on base window.");
	report_strategy("Set override-redirect attribute to False.");
	report_strategy("Select StructureNotify events on window.");
	report_strategy("Create second client.");
	report_strategy("Select SubstructureNotify for second client on base window.");
	report_strategy("Map window.");
	report_strategy("Verify that a MapNotify event is generated on parent.");
	report_strategy("Verify that a MapNotify event is generated on window.");
	report_strategy("Verify that the map_state of the window is IsViewable.");

	tpstartup();
	setargs();
	base = defwin(display);
	setarea(&area, 20, 20, 40, 40);
	w = creunmapchild(display, base, &area);
	setatts.override_redirect = False;
	XChangeWindowAttributes(display, w, CWOverrideRedirect, &setatts);
	/*
	 * Would normally select ALLEVENTS to test for spurious events.
	 * This cannot be done here, since we would possibly get valid 
	 * EnterNotify's etc.
	 */
	XSelectInput(display, w, StructureNotifyMask);
	if (isdeleted())
		return;

	client2 = opendisplay();
	XSelectInput(client2, base, SubstructureNotifyMask);
	XSync(client2, True);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

	/*
	 * Check for Map event on parent.
	 */
	good.type = MapNotify;
	good.serial = 0;
	good.send_event = False;
	good.display = client2;
	good.event = base;
	good.window = w;
	good.override_redirect = False;

	n = getevent(client2, &ev);
	if (n != 1) {
		report("Expecting one event on second client, received %d", n);
		FAIL;
	} else if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;

	/*
	 * Now check for map notify on the window itself.
	 */
	good.display = display;
	good.event = w;

	n = getevent(display, &ev);
	if (n != 1) {
		report("Expecting one Map notify event, received %d events", n);
		FAIL;
	} else if (checkevent((XEvent*)&good, &ev))
		FAIL;
	else
		CHECK;

	XGetWindowAttributes(display, w, &atts);
	if (atts.map_state != IsViewable) {
		report("map state after map was %s, expecting %s",
			mapstatename(atts.map_state), mapstatename(IsViewable));
		FAIL;
	} else
		CHECK;

	CHECKPASS(3);
	tpcleanup();
	pfcount(pass, fail);
}

static void t009(){

Window	base;
Window	win;
Pixmap	tile;
int 	pass = 0, fail = 0;

 	report_purpose(9);

	report_assertion("Assertion XMapWindow-9.(A)");
	report_assertion("When the window or one of its inferiors becomes viewable");
	report_assertion("after a call to XMapWindow and no earlier contents for it");
	report_assertion("are remembered, then the window is tiled with its");
	report_assertion("background.");

	report_strategy("Create window.");
	report_strategy("Set background to tile.");
	report_strategy("Map window.");
	report_strategy("Verify that window is tiled.");
	report_strategy("Re-run with an inferior window.");

	tpstartup();
	setargs();
	base = defwin(display);

	w = creunmapchild(display, base, (struct area *)0);

	tile = maketile(display, w);
	XSetWindowBackgroundPixmap(display, w, tile);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (checktile(display, w, (struct area *)0, 0, 0, tile))
		CHECK;
	else {
		report("Window not tiled with its background correctly");
		FAIL;
	}

	/*
	 * Create an unmapped window and a mapped inferior of that window.
	 * When we map the window the inferior becomes viewable and so it
	 * should be tiled.
	 */
	base = defwin(display);
	w = creunmapchild(display, base, (struct area *)0);
	win = crechild(display, w, (struct area *)0);
	XSetWindowBackgroundPixmap(display, win, tile);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (checktile(display, win, (struct area *)0, 0, 0, tile))
		CHECK;
	else {
		report("Inferior window not tiled with its background correctly");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t010(){

Window	base;
Window	ch1;
XImage	*imp;
struct	area	area;
int 	pass = 0, fail = 0;

 	report_purpose(10);

	report_assertion("Assertion XMapWindow-10.(A)");
	report_assertion("When the background of the window is undefined then the");
	report_assertion("existing screen contents from the parent or an inferior of");
	report_assertion("the parent are not altered, and zero or more Expose events");
	report_assertion("are generated.");

	report_strategy("Create window as parent.");
	report_strategy("Draw pattern on parent.");
	report_strategy("Create inferior window and draw pattern on that too.");
	report_strategy("Create unmapped inferior that overlaps other inferior.");
	report_strategy("Set background pixmap to None to undefine background.");
	report_strategy("Map window.");
	report_strategy("Verify that screen contents have not been altered.");
	report_strategy("");
	report_strategy("Unmap window.");
	report_strategy("Select for expose events.");
	report_strategy("Call setforexpose() to draw into window (only effective if backing store in use)");
	report_strategy("Call XMapWindow to map window.");
	report_strategy("Verify that window was restored from backing store or received expose");
	report_strategy("events to cover the window with exposecheck().");

	tpstartup();
	setargs();
	base = defwin(display);
	pattern(display, base);

	setarea(&area, 7, 7, 50, 50);
	ch1 = crechild(display, base, &area);
	pattern(display, ch1);

	/* Save original contents */
	imp = savimage(display, base);

	setarea(&area, 5, 5, 70, 40);
	w = creunmapchild(display, base, &area);
	XSetWindowBackgroundPixmap(display, w, None);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (compsavimage(display, base, imp))
		CHECK;
	else {
		report("Screen contents altered by mapping window with undefined background");
		FAIL;
	}

	/*
	 * Check expose events.  Unmap the window and draw into it with
	 * setforexpose(), (this will normally have no effect unless backing
	 * store is active).  Map the window and check that either
	 *  - there are zero expose events and backing store has preserved the
	 *    contents.
	 *  - there are enough expose events to cover the window.
	 */
	XUnmapWindow(display, w);

	XSelectInput(display, w, ExposureMask);
	setforexpose(display, w);
	/* because setforexpose() changes the background */
	XSetWindowBackgroundPixmap(display, w, None);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (exposecheck(display, w))
		CHECK;
	else {
		report("Neither Expose events or backing store processing");
		report("could correctly restore the window contents.");
		FAIL;
	}

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.26146 */
static void t011(){

int 	pass = 0, fail = 0;

 	report_purpose(11);

	report_assertion("Assertion XMapWindow-11.(B)");
	report_assertion("When the background of the window is undefined then the");
	report_assertion("existing screen contents not from the parent or an inferior");
	report_assertion("of the parent are undefined, and zero or more Expose events");
	report_assertion("are generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	UNTESTED;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.26146 */

static void t012(){

XSetWindowAttributes	setatts;
XEvent	ev;
int 	pass = 0, fail = 0;

 	report_purpose(12);

	report_assertion("Assertion XMapWindow-12.(D)");
	report_assertion("If backing store is supported: When backing store has been");
	report_assertion("maintained while a particular window was unmapped, then no");
	report_assertion("Expose events are generated for that window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If backing store is supported");
	report_strategy("  Create window.");
	report_strategy("  Set backing store hint to Always.");
	report_strategy("  Write into window.");
	report_strategy("  Unmap window.");
	report_strategy("  Enable Expose events.");
	report_strategy("  Map window.");
	report_strategy("  If window contents are unaltered.");
	report_strategy("	Backing store was maintained.");
	report_strategy("	Verify that no Expose events were received.");
	report_strategy("  else");
	report_strategy("	Backing store was not maintained.");
	report_strategy("	Test result is UNTESTED.");
	report_strategy("else");
	report_strategy("  Test result is UNSUPPORTED.");

	tpstartup();
	setargs();
	if (DoesBackingStore(DefaultScreenOfDisplay(display)) != Always) {
		unsupported("Backing store not supported while unmapped");
		return;
	}

	w = defwin(display);
	setatts.backing_store = Always;
	XChangeWindowAttributes(display, w, CWBackingStore, &setatts);

	dset(display, w, W_FG);
	XUnmapWindow(display, w);
	XSelectInput(display, w, ExposureMask);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	XSelectInput(display, w, NoEventMask);

	if (checkarea(display, w, (struct area *)0, W_FG, W_FG, CHECK_ALL|CHECK_DIFFER)) {
		/*
		 * Backing store apeared to be active during the unmap.
		 */
		if (XCheckTypedWindowEvent(display, w, Expose, &ev)) {
			/* Received Exposes */
			report("Expose received when backing store was active");
			FAIL;
		} else
			CHECK;
	} else {
		/*
		 * There is nothing wrong here, but it is possibly of interest.
		 */
		trace("NOTE: Server claims to support backing store but it was not active in the test");
		UNTESTED;
	}

	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

static void t013(){

int 	n;
Window	base;
Window	ch1;
XEvent	ev;
struct	area	area;
struct	area	charea;
XExposeEvent	*ep;
XSetWindowAttributes	setatts;
int 	pass = 0, fail = 0;

 	report_purpose(13);

	report_assertion("Assertion XMapWindow-13.(D)");
	report_assertion("If backing store is supported: When the server elects to");
	report_assertion("now maintain backing store for a window, then an Expose");
	report_assertion("event for the whole window is generated.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("If backing store is supported.");
	report_strategy("  Create small window.");
	report_strategy("  Ask for backing store when mapped.");
	report_strategy("  Create (and map) windows that would obscure the test window.");
	report_strategy("  Enable Expose events.");
	report_strategy("  Map window.");
	report_strategy("  If no Expose");
	report_strategy("	Untested - maybe got backing store always.");
	report_strategy("  Verify Expose event is for whole window.");
	report_strategy("else");
	report_strategy("  Untested.");

	tpstartup();
	setargs();
	if (DoesBackingStore(DefaultScreenOfDisplay(display)) == NotUseful) {
		unsupported("Backing store is not supported");
		return;
	}

	base = defwin(display);

	setarea(&area, 0, 0, 70, 70);
	w = creunmapchild(display, base, &area);
	setatts.backing_store = WhenMapped;
	XChangeWindowAttributes(display, w, CWBackingStore, &setatts);

	/* Create a child that will cover the test window */
	setarea(&charea, 0, 0, 20, 20);
	ch1 = crechild(display, base, &charea);

	XSelectInput(display, w, ExposureMask);
	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSelectInput(display, w, NoEventMask);

	n = XPending(display);
	if (n == 0) {
		trace("No Expose events on mapping window with backing-store WhenMapped");
		UNTESTED;
	} else
		CHECK;

	if (n == 1) {
		getevent(display, &ev);
		if (ev.type != Expose) {
			/* Only Expose events were enabled */
			delete("Unexpected event received (%s)", eventname(ev.type));
		} else {
			ep = (XExposeEvent*)&ev;
			if (ep->x == area.x && ep->y == area.y && ep->width == area.width && ep->height == area.height) {
				/* Full window Expose received */
				CHECK;
			} else {
				/*
				 * Since there was only one event and it does not cover
				 * the whole window then it is incorrect.
				 */
				report("Expose event covered wrong area");
				report("x=%d, y=%d, width=%d, height=%d", ep->x, ep->y, ep->width, ep->height);
				FAIL;
			}
		}
	} else {
		trace("Did not appear to get backing store");
		UNTESTED;
	}
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

static void t014(){

int 	n;
Window	base;
Window	ch1;
struct	area	area;
struct	area	charea;
XSetWindowAttributes	setatts;
int 	pass = 0, fail = 0;

 	report_purpose(14);

	report_assertion("Assertion XMapWindow-14.(B)");
	report_assertion("When the server elects to not maintain backing store for a");
	report_assertion("window, then Expose events are generated only for visible");
	report_assertion("regions.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Create small window.");
	report_strategy("Ask for no backing store.");
	report_strategy("Create (and map) windows that would obscure the test window.");
	report_strategy("Map window.");
	report_strategy("If Expose event is for whole window.");
	report_strategy("  Untested - maybe got backing store.");
	report_strategy("else");
	report_strategy("  Verify that only visible regions got Expose events.");

	tpstartup();
	setargs();
	base = defwin(display);

	setarea(&area, 0, 0, 70, 70);
	w = creunmapchild(display, base, &area);
	setatts.backing_store = NotUseful;
	XChangeWindowAttributes(display, w, CWBackingStore, &setatts);

	/* Create a child that will cover the test window */
	setarea(&charea, 0, 0, 20, 20);
	ch1 = crechild(display, base, &charea);

	XSelectInput(display, w, ExposureMask);
	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSelectInput(display, w, NoEventMask);

	n = XPending(display);
	if (n == 0) {
		trace("No Expose events on mapping window with backing-store NotUseful");
		UNTESTED;
	} else
		CHECK;

	if (n == 1) {
		trace("Appeared to get backing store when asked for NotUseful");
		UNTESTED;
	} else {
		/*
		 * Remove the child window.  Clear the test window, and then
		 * redraw it according to the Expose events.  This should leave
		 * the part that was not visible after the map in the background
		 * pixel.
		 */
		XUnmapWindow(display, ch1);
		dclear(display, w);
		exposefill(display, w);
		if (checkarea(display, w, &charea, W_BG, W_FG, CHECK_ALL))
			CHECK;
		else {
			report("Some part of non-visible regions received Expose events");
			report("  or not all visible regions exposed");
			FAIL;
		}
	}

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EWin.mc */
/* End of included file error/EWin.mc */

/* Including from file error/EWin.mc */
static void t015(){

int 	pass = 0, fail = 0;

 	report_purpose(15);

	report_assertion("Assertion XMapWindow-15.(A)");
	report_assertion("When a window argument does not name a valid Window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("Create a bad window by creating and destroying a window.");
	report_strategy("Call test function using bad window as the window argument.");
	report_strategy("Verify that a BadWindow error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	A_WINDOW = badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	XMapWindow(display, w);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadWindow)
		PASS;
	else
		FAIL;

	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EWin.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
