/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XmbTextListToTextProperty()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xresource.h>
#include <X11/Xproto.h>
#include <X11/Xcms.h>
#include <xtestlib.h>
#include <tet_api.h>
#include <r5structs.h>
#include <r5decl.h>
/*error messages created here*/
char	ebuf[4096];

#define T_XmbTextListToTextProperty	1
char    *TestName = "XmbTextListToTextProperty";




char *list[] = { "Xlib test string abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" } ;
int length_good = 79;

Display	   *display_good;
                                
char *exec_file_name;
int x_init, y_init, w_init, h_init;

svcmbTextListToTextProperty(display, list_good, 
	count_good, style_good, text_prop_good )
Display     *display ;
char	**list_good ;
int		count_good ;
XICCEncodingStyle style_good ;
XTextProperty	text_prop_good ;
{
        extern int  errflg;
        extern int  chkflg;
	extern int  signal_status();
	extern int  unexp_err();
	extern char *strcpy();

        Status ret_status ;

	int ss_status,	/* save stat return status */	
	    stat_status,	/* check stat return status */
	    setup_status,
	    cleanup_status;

	regr_args.l_flags.bufrout = 1;

	/* buffer display struct info for error checking */
	bufrdisp(display_good);	

	if (regr_args.l_flags.setup) 
		setup_status = REGR_NORMAL;
	XSync(display_arg, 0);

	if (regr_args.l_flags.chksta  == 1)
		ss_status = save_stat(dpy_msk, gc_id,
		       display_arg, drawable_id);
				

	first_error = 0;	/* no errors encountered yet */

	errflg = 0;
	XSetErrorHandler(signal_status);

	tet_infoline("PREP: Call XmbTextListToTextProperty with a multi-byte list");
	ret_status = XmbTextListToTextProperty(
		 display, list_good, count_good,
		 style_good, &text_prop_good);

	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          
	/* no colormap by default */
	r_wait(display_arg, window_arg, time_delay, None);

	if (regr_args.l_flags.chksta  == 1) 
		stat_status = chek_stat (dpy_msk ,
				 gc_id, display_arg,
				 drawable_id, ss_status);
	else                              
		stat_status = REGR_NORMAL;


	if ((!errflg) && (!chkflg)) 
		if ((badstat(display_arg, estatus, Success)) != 
		    REGR_NORMAL)
	    errflg = 1;

	tet_infoline("TEST: Call returns Success");
	if ((regr_args.l_flags.check) && 
	    (errflg == 0) && 
	    (stat_status == REGR_NORMAL)) 
	{

		if (ret_status != Success) 
		{
	    		message("XmbTextListToTextProperty failed: Expected zero returned non zero\n", NULL, 0);
	    		errflg = 1 ;
	    	} 
		else
		{
			tet_infoline("TEST: Value of Property returned");
	    		check_str(list[0], text_prop_good.value, 
				"string");
	    		check_dec(length_good, text_prop_good.nitems, 
				"nitems");
	    	}
	}
	XSync(display_arg, 0);

	if (regr_args.l_flags.cleanup)
		cleanup_status = REGR_NORMAL;

	XSync(display_arg, 0);

	chkflg = 0;
  	regr_args.l_flags.bufrout = 0;

        dumpbuf();
}


int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){


 	report_purpose(1);

	report_assertion("Assertion XmbTextListToTextProperty-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XmbTextListToTextProperty shall convert an internationalized");
	report_assertion("multi-byte text list to a list property structure and return");
	report_assertion("Success.");
#if XT_X_RELEASE > 4
	display_arg = Dsp;
	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

	regr_args.l_flags.check = 0;
	regr_args.l_flags.nostat = 0;
	regr_args.l_flags.perf = 0;
	regr_args.l_flags.setup = 0;
	regr_args.l_flags.cleanup = 0;
	regr_args.l_flags.chksta = 0;
	regr_args.l_flags.chkdpy = 0;
	regr_args.l_flags.verbose = 0;
	regr_args.iter = 1;	/* execute service once	*/
	estatus[0] = 1;


	display_good = display_arg;

        estatus[0] = 1;
        estatus[1] = Success;

	if ((regr_args.l_flags.good == 0) || (estatus[1] == Success)) 
	{
		tet_infoline("TEST: set text list to XTextProperty structure\n");
                regr_args.l_flags.setup = 1;
                regr_args.l_flags.cleanup = 1;
                regr_args.l_flags.check = 1;
                regr_args.l_flags.chksta = 1;

                {
                    XTextProperty 	text_prop ;
                    int count = 1;

                    svcmbTextListToTextProperty(
                         display_good,
                         list,
                         count,
                         (XICCEncodingStyle)XStdICCTextStyle,
                         &text_prop
                        );
                }
	}
	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9505 */
/* End of included file Mdefcode.tmc.9505 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = r5_startup;
void	(*tet_cleanup)() = r5_cleanup;
