/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Widget
 *   XtCreateApplicationShell()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtCreateApplicationShell	1
char    *TestName = "XtCreateApplicationShell";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
Widget widget_good, labelw_good;
Boolean status;
Arg setargs[2];
pid_t pid2;
pid_t pid3;
int pstatus;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtCreateApplicationShell-1.(A)");
	report_assertion("A successful call to Widget XtCreateApplicationShell(name,");
	report_assertion("widget_class, args, num_args) shall create a top-level shell");
	report_assertion("widget that is the root of a widget tree with name as the");
	report_assertion("widget instance name and return the shell widget instance.");
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tcrappshl1", "XtCreateApplicationShell");
	FORK(pid2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Create additional top-level widget");
	setargs[0].name = (String)XtNwidth;
	setargs[0].value = (XtArgVal)100;
	setargs[1].name = (String)XtNheight;
	setargs[1].value = (XtArgVal)100;
	widget_good = XtCreateApplicationShell(
		"Tcrappshl1",	/* application name */
		applicationShellWidgetClass, /* widget class */
		&setargs[0],
		(Cardinal)2
		);
	tet_infoline("TEST: Widget_good class is applicationShellWidgetClass");
	status = XtIsApplicationShell(widget_good);
	check_dec(True, status, "XtIsApplicationShell return value");
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else
		tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12314 */
/* End of included file Mdefcode.tmc.12314 */

/* Including from file Mdefcode.tmc.12314 */
static void t002(){

pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtCreateApplicationShell-2.(B)");
	report_assertion("On a successful call to Widget");
	report_assertion("XtCreateApplicationShell(name, widget_class, args, num_args)");
	report_assertion("when widget_class is ApplicationShell or a subclass thereof");
	report_assertion("the shell widget instance created shall have the WM_COMMAND");
	report_assertion("property set from the values of the XtNargv and XtNargc");
	report_assertion("resources.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12314 */

static void t003(){

Display *display_good;
Widget widget_good, labelw_good;
Boolean status;
Arg setargs[2];
pid_t pid2;
pid_t pid3;
int pstatus;
String	name_good, class_good;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtCreateApplicationShell-3.(A)");
	report_assertion("A successful call to Widget XtCreateApplicationShell(name,");
	report_assertion("widget_class, args, num_args) when name is NULL shall name");
	report_assertion("the shell widget instance with the application name passed");
	report_assertion("to XtDisplayInitialize.");
	FORK(pid);
	initconfig();

	FORK(pid3);
	avs_xt_hier_def("Tcrappshl2", "XtCreateApplicationShell");
	FORK(pid2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Create additional top-level widget");
	setargs[0].name = (String)XtNwidth;
	setargs[0].value = (XtArgVal)100;
	setargs[1].name = (String)XtNheight;
	setargs[1].value = (XtArgVal)100;
	widget_good = XtCreateApplicationShell(
		NULL,	/* application name */
		applicationShellWidgetClass, /* widget class */
		&setargs[0],
		(Cardinal)2
		);
	tet_infoline("TEST: Application name");
	display_good = XtDisplay(widget_good);
        XtGetApplicationNameAndClass(display_good, &name_good, &class_good );
        check_str("main", name_good, "Application Name");
	LKROF(pid2, AVSXTTIMEOUT-4);
	KROF3(pid3, pstatus, AVSXTTIMEOUT-2);
        if (pstatus != 0) {
		tet_infoline("ERROR: Test process exited abnormally");
		tet_infoline("       May mean display cannot be opened");
		tet_result(TET_UNRESOLVED);
        }
	else
		tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12314 */
/* End of included file Mdefcode.tmc.12314 */

/* Including from file Mdefcode.tmc.12314 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtCreateApplicationShell-4.(B)");
	report_assertion("A successful call to Widget XtCreateApplicationShell(name,");
	report_assertion("widget_class, args, num_args) when args specifies the");
	report_assertion("XtNscreen argument shall create the resource database for");
	report_assertion("the shell widget using the resource values specified in args");
	report_assertion("and resource values from the resource database of the screen");
	report_assertion("specified by the XtNscreen argument for those resources not");
	report_assertion("specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12314 */

/* Including from file Mdefcode.tmc.12314 */
static void t005(){

pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtCreateApplicationShell-5.(B)");
	report_assertion("A successful call to Widget XtCreateApplicationShell(name,");
	report_assertion("widget_class, args, num_args) when args does not specify the");
	report_assertion("XtNscreen argument, widget_class is");
	report_assertion("applicationShellWidgetClass or a subclass thereof, and the");
	report_assertion("resource database of the default screen for display");
	report_assertion("specifies the resource name.screen, class class.screen,");
	report_assertion("where class is the application class passed to XtInitialize,");
	report_assertion("shall create the resource database for the shell widget");
	report_assertion("using the resource values specified in args and resource");
	report_assertion("values from the resource database of the screen specified in");
	report_assertion("the resource database of the default screen for those");
	report_assertion("resources not specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12314 */

/* Including from file Mdefcode.tmc.12314 */
static void t006(){

pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtCreateApplicationShell-6.(B)");
	report_assertion("A successful call to Widget XtCreateApplicationShell(name,");
	report_assertion("widget_class, args, num_args) when args does not specify the");
	report_assertion("XtNscreen argument, widget_class is not");
	report_assertion("applicationShellWidgetClass or a subclass thereof, and the");
	report_assertion("resource database of the default screen for display");
	report_assertion("specifies the resource name.screen, class Class.screen,");
	report_assertion("where Class is the class_name field from CoreClassPart of");
	report_assertion("widget_class, shall create the resource database for the");
	report_assertion("shell widget using the resource values specified in args and");
	report_assertion("resource values from the resource database of the screen");
	report_assertion("specified in the resource database of the default screen for");
	report_assertion("those resources not specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12314 */

/* Including from file Mdefcode.tmc.12314 */
static void t007(){

pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtCreateApplicationShell-7.(B)");
	report_assertion("A successful call to Widget XtCreateApplicationShell(name,");
	report_assertion("widget_class, args, num_args) when args does not specify the");
	report_assertion("XtNscreen argument and the resource database of the default");
	report_assertion("screen for display does not specify the resource");
	report_assertion("name.screen, class class.screen, where class is the");
	report_assertion("application class passed to XtInitialize, shall create the");
	report_assertion("resource database for the shell widget using the resource");
	report_assertion("values specified in args and resource values from the");
	report_assertion("resource database of the default screen for those resources");
	report_assertion("not specified in args.");
	report_assertion("Reason for omission: Temporarily can't be implemented");
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* End of included file Mdefcode.tmc.12314 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
